/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.validation;

import info.rexs.model.RexsAttribute;
import info.rexs.model.RexsComponent;
import info.rexs.schema.IRexsSchemaRegistry;
import info.rexs.schema.RexsSchemaRegistry;
import info.rexs.schema.constants.RexsComponentType;
import info.rexs.schema.constants.RexsUnitId;
import info.rexs.schema.constants.RexsVersion;
import info.rexs.schema.constants.standard.RexsStandardUnitIds;
import info.rexs.validation.DefaultRexsAttributeValidator;
import info.rexs.validation.RexsValidationResult;
import info.rexs.validation.RexsValidationResultMessageKey;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class RexsStandardAttributeValidator
extends DefaultRexsAttributeValidator {
    protected final IRexsSchemaRegistry rexsSchemaRegistry;
    protected final RexsVersion rexsVersion;

    public RexsStandardAttributeValidator(RexsVersion rexsVersion) {
        this(rexsVersion, RexsSchemaRegistry.getInstance());
    }

    public RexsStandardAttributeValidator(RexsVersion rexsVersion, IRexsSchemaRegistry rexsSchemaRegistry) {
        Objects.nonNull(rexsSchemaRegistry);
        this.rexsVersion = rexsVersion;
        this.rexsSchemaRegistry = rexsSchemaRegistry;
    }

    @Override
    public RexsValidationResult validate(RexsAttribute rexsAttribute, RexsComponent rexsComponent) {
        RexsValidationResult validationResult = super.validate(rexsAttribute, rexsComponent);
        if (this.rexsVersion == null) {
            return validationResult;
        }
        String componentType = rexsComponent.getOriginType();
        RexsComponentType rexsComponentType = this.rexsSchemaRegistry.getComponentType(this.rexsVersion, componentType);
        String attributeId = rexsAttribute.getOriginAttributeId();
        boolean attributeKnown = true;
        if (!this.rexsSchemaRegistry.hasAttributeWithId(this.rexsVersion, attributeId)) {
            if (StringUtils.startsWith((CharSequence)attributeId, (CharSequence)"custom_")) {
                validationResult.addWarning(RexsValidationResultMessageKey.ATTRIBUTE_ID_CUSTOM, attributeId);
            } else {
                validationResult.addError(RexsValidationResultMessageKey.ATTRIBUTE_ID_UNKNOWN, attributeId);
            }
            attributeKnown = false;
        } else if (!this.rexsSchemaRegistry.componentAttributeMappingExists(attributeId, rexsComponentType, this.rexsVersion)) {
            validationResult.addError(RexsValidationResultMessageKey.ATTRIBUTE_COMPONENT_MAPPING_UNKNOWN, rexsComponent.toString(), attributeId);
        }
        validationResult.add(this.validateUnit(rexsAttribute.getOriginUnit(), rexsComponent.toString(), attributeId, attributeKnown));
        return validationResult;
    }

    private RexsValidationResult validateUnit(String unit, String componentName, String attributeId, boolean attributeKnown) {
        RexsUnitId dbUnitId;
        RexsValidationResult validationResult = new RexsValidationResult();
        if (unit == null || unit.isEmpty()) {
            return validationResult;
        }
        RexsUnitId unitId = RexsUnitId.findById(unit);
        if (unitId == null || unitId.isOneOf(RexsStandardUnitIds.UNKNOWN)) {
            validationResult.addError(RexsValidationResultMessageKey.UNIT_UNKNOWN, unit);
        }
        if (unitId != null && attributeKnown && !unitId.equals(dbUnitId = this.rexsSchemaRegistry.getAttributeUnit(attributeId, this.rexsVersion))) {
            String additionalMessage = String.format("expected: \"%s\" but was: \"%s\"", dbUnitId.getId(), unit);
            validationResult.addError(RexsValidationResultMessageKey.ATTRIBUTE_UNIT_MAPPING_UNKNOWN, attributeId, componentName, additionalMessage);
        }
        return validationResult;
    }
}

