/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.validation;

import info.rexs.model.RexsModel;
import info.rexs.model.RexsRelation;
import info.rexs.model.RexsRelationRef;
import info.rexs.schema.IRexsSchemaRegistry;
import info.rexs.schema.RexsSchemaRegistry;
import info.rexs.schema.constants.RexsComponentType;
import info.rexs.schema.constants.RexsRelationRole;
import info.rexs.schema.constants.RexsVersion;
import info.rexs.schema.jaxb.AllowedCombinationRole;
import info.rexs.validation.DefaultRexsRelationValidator;
import info.rexs.validation.RexsValidationResult;
import info.rexs.validation.RexsValidationResultMessageKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RexsStandardRelationValidator
extends DefaultRexsRelationValidator {
    protected final IRexsSchemaRegistry rexsSchemaRegistry;
    protected final RexsVersion rexsVersion;

    public RexsStandardRelationValidator(RexsVersion rexsVersion) {
        this(rexsVersion, RexsSchemaRegistry.getInstance());
    }

    public RexsStandardRelationValidator(RexsVersion rexsVersion, IRexsSchemaRegistry rexsSchemaRegistry) {
        Objects.nonNull(rexsSchemaRegistry);
        this.rexsVersion = rexsVersion;
        this.rexsSchemaRegistry = rexsSchemaRegistry;
    }

    @Override
    public RexsValidationResult validate(RexsRelation rexsRelation, RexsModel rexsModel) {
        RexsValidationResult validationResult = super.validate(rexsRelation, rexsModel);
        validationResult.add(this.checkIfRolesAreValidForTheRelationType(rexsRelation));
        if (this.rexsVersion == null) {
            return validationResult;
        }
        if (this.rexsSchemaRegistry.hasRelationTypes(this.rexsVersion)) {
            validationResult.add(this.checkIfIsAllowedCombination(rexsRelation, rexsModel));
        }
        return validationResult;
    }

    private RexsValidationResult checkIfIsAllowedCombination(RexsRelation rexsRelation, RexsModel rexsModel) {
        RexsValidationResult validationResult = new RexsValidationResult();
        try {
            List<List<AllowedCombinationRole>> listOfAllowedCombinations = this.rexsSchemaRegistry.getAllowedCombinationsForRelation(this.rexsVersion, rexsRelation.getType());
            HashMap<RexsRelationRole, RexsComponentType> mapRoleToComponentType = new HashMap<RexsRelationRole, RexsComponentType>();
            for (RexsRelationRef rexsRelationRef : rexsRelation.getRefs()) {
                mapRoleToComponentType.put(rexsRelationRef.getRole(), rexsModel.getComponent(rexsRelationRef.getId()).getType());
            }
            for (List list : listOfAllowedCombinations) {
                if (!this.allowedCombinationMatches(list, mapRoleToComponentType)) continue;
                return validationResult;
            }
            validationResult.addError(RexsValidationResultMessageKey.RELATION_NOT_ALLOWED_COMBINATION, String.valueOf(rexsRelation.getId()), rexsRelation.getType().getKey(), this.translateRelationForMessage(rexsRelation, rexsModel));
        }
        catch (IllegalArgumentException ex) {
            validationResult.addError(RexsValidationResultMessageKey.CAUGHT_EXCEPTION, ex.getMessage());
        }
        return validationResult;
    }

    private String translateRelationForMessage(RexsRelation rexsRelation, RexsModel rexsModel) {
        StringBuilder builder = new StringBuilder();
        for (RexsRelationRef ref : rexsRelation.getRefs()) {
            builder.append(ref.getRole());
            builder.append("=");
            builder.append(rexsModel.getComponent(ref.getId()).toString());
            builder.append(";  ");
        }
        return builder.toString();
    }

    private boolean allowedCombinationMatches(List<AllowedCombinationRole> allowedCombination, Map<RexsRelationRole, RexsComponentType> mapRoleToComponentType) {
        for (RexsRelationRole role : mapRoleToComponentType.keySet()) {
            Optional<String> allowedComponentTypeForRole = allowedCombination.stream().filter(a -> a.getRoleId().equals(role.getKey())).map(AllowedCombinationRole::getComponentId).findFirst();
            if (!allowedComponentTypeForRole.isEmpty() && allowedComponentTypeForRole.get().equals(mapRoleToComponentType.get(role).getId())) continue;
            return false;
        }
        return true;
    }

    private RexsValidationResult checkIfRolesAreValidForTheRelationType(RexsRelation rexsRelation) {
        RexsValidationResult validationResult = new RexsValidationResult();
        List<RexsRelationRole> rolesOfRelation = rexsRelation.getType().getRoles();
        for (RexsRelationRef ref : rexsRelation.getRefs()) {
            if (rolesOfRelation.contains(ref.getRole())) continue;
            validationResult.addError(RexsValidationResultMessageKey.RELATION_ROLE_INVALID_FOR_RELATION_TYPE, ref.getRole().getKey(), rexsRelation.getType().getKey());
        }
        return validationResult;
    }
}

