/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.db;

import info.rexs.db.DbModelResolver;
import info.rexs.db.IDbModelRegistry;
import info.rexs.db.constants.RexsComponentType;
import info.rexs.db.constants.RexsRelationType;
import info.rexs.db.constants.RexsUnitId;
import info.rexs.db.constants.RexsValueType;
import info.rexs.db.constants.RexsVersion;
import info.rexs.db.constants.standard.RexsStandardComponentTypes;
import info.rexs.db.constants.standard.RexsStandardUnitIds;
import info.rexs.db.constants.standard.RexsStandardVersions;
import info.rexs.db.jaxb.AllowedCombination;
import info.rexs.db.jaxb.AllowedCombinationRole;
import info.rexs.db.jaxb.AllowedCombinations;
import info.rexs.db.jaxb.Attribute;
import info.rexs.db.jaxb.Component;
import info.rexs.db.jaxb.ComponentAttributeMapping;
import info.rexs.db.jaxb.EnumValue;
import info.rexs.db.jaxb.Relation;
import info.rexs.db.jaxb.RexsDatabaseModelFile;
import info.rexs.db.jaxb.Unit;
import info.rexs.db.jaxb.ValueType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DbModelRegistry
implements IDbModelRegistry {
    private static DbModelRegistry instance = null;
    private Map<String, RexsVersion> versions = new HashMap<String, RexsVersion>();
    private Map<RexsVersion, Map<String, RexsComponentType>> componentMap = new HashMap<RexsVersion, Map<String, RexsComponentType>>();
    private Map<RexsVersion, Map<String, RexsUnitId>> attributeUnits = new HashMap<RexsVersion, Map<String, RexsUnitId>>();
    private Map<RexsVersion, Map<String, RexsValueType>> attributeTypes = new HashMap<RexsVersion, Map<String, RexsValueType>>();
    private Map<RexsVersion, Map<String, Attribute>> attributeMap = new HashMap<RexsVersion, Map<String, Attribute>>();
    private Map<RexsVersion, Map<String, List<RexsComponentType>>> attributeToComponentMap = new HashMap<RexsVersion, Map<String, List<RexsComponentType>>>();
    private Map<RexsVersion, Map<RexsComponentType, List<String>>> componentToAttributesMap = new HashMap<RexsVersion, Map<RexsComponentType, List<String>>>();
    private Map<RexsVersion, Map<RexsRelationType, List<List<AllowedCombinationRole>>>> relationsToAllowedCombinationsMap = new HashMap<RexsVersion, Map<RexsRelationType, List<List<AllowedCombinationRole>>>>();

    private DbModelRegistry() {
        try {
            this.registerRexsVersion(RexsStandardVersions.V1_0);
            this.registerRexsVersion(RexsStandardVersions.V1_1);
            this.registerRexsVersion(RexsStandardVersions.V1_2);
            this.registerRexsVersion(RexsStandardVersions.V1_3);
            this.registerRexsVersion(RexsStandardVersions.V1_4);
            this.registerRexsVersion(RexsStandardVersions.V1_5);
            this.registerRexsVersion(RexsStandardVersions.V1_6);
        }
        catch (Exception ex) {
            throw new RuntimeException("error while registering rexs model:", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbModelRegistry getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<DbModelRegistry> clazz = DbModelRegistry.class;
        synchronized (DbModelRegistry.class) {
            if (instance == null) {
                instance = new DbModelRegistry();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void registerRexsVersion(RexsVersion version) {
        RexsDatabaseModelFile rexsModel = DbModelResolver.getInstance().resolve(version);
        if (rexsModel == null) {
            throw new IllegalStateException(String.format("rexs db model for version %s not found", version.getName()));
        }
        this.registerRexsModel(version, rexsModel);
        this.versions.put(version.getName(), version);
    }

    private void registerRexsModel(RexsVersion version, RexsDatabaseModelFile rexsModel) {
        this.generateComponentMap(version, rexsModel);
        this.generateAttributeMap(version, rexsModel);
        this.generateAttributeTypeMap(version, rexsModel);
        this.generateAttributeUnitMap(version, rexsModel);
        this.generateAttributeComponentMappings(version, rexsModel);
        if (version.isGreater(RexsStandardVersions.V1_6)) {
            this.generateRelationsWithAllowedCombinations(version, rexsModel);
        }
    }

    private void generateRelationsWithAllowedCombinations(RexsVersion version, RexsDatabaseModelFile rexsModel) {
        Map relationsToAllowedCombinationsMapofVersion = this.relationsToAllowedCombinationsMap.computeIfAbsent(version, k -> new HashMap());
        if (rexsModel.getRelations() != null) {
            for (Relation relation : rexsModel.getRelations().getRelation()) {
                RexsRelationType relationType = RexsRelationType.findByKey(relation.getRelationId());
                List listOfCombinations = relationsToAllowedCombinationsMapofVersion.computeIfAbsent(relationType, k -> new ArrayList());
                AllowedCombinations combinations = relation.getAllowedCombinations();
                for (AllowedCombination combination : combinations.getAllowedCombination()) {
                    listOfCombinations.add(combination.getAllowedCombinationRole());
                }
            }
        }
    }

    private void generateComponentMap(RexsVersion version, RexsDatabaseModelFile rexsModel) {
        Map mapOfVersion = this.componentMap.computeIfAbsent(version, k -> new HashMap());
        for (Component component : rexsModel.getComponents().getComponent()) {
            RexsComponentType componentType = RexsComponentType.findById(component.getComponentId());
            mapOfVersion.put(component.getComponentId(), componentType);
        }
    }

    private void generateAttributeMap(RexsVersion version, RexsDatabaseModelFile rexsModel) {
        Map mapofVersion = this.attributeMap.computeIfAbsent(version, k -> new HashMap());
        for (Attribute attribute : rexsModel.getAttributes().getAttribute()) {
            mapofVersion.put(attribute.getAttributeId(), attribute);
        }
    }

    private void generateAttributeTypeMap(RexsVersion version, RexsDatabaseModelFile rexsModel) {
        Map mapofVersion = this.attributeTypes.computeIfAbsent(version, k -> new HashMap());
        HashMap<BigInteger, String> valueTypeMap = new HashMap<BigInteger, String>();
        if (rexsModel.getValueTypes() != null) {
            for (ValueType valueType : rexsModel.getValueTypes().getValueType()) {
                valueTypeMap.put(valueType.getId(), valueType.getName());
            }
        }
        if (rexsModel.getAttributes() != null) {
            for (Attribute attribute : rexsModel.getAttributes().getAttribute()) {
                mapofVersion.put(attribute.getAttributeId(), RexsValueType.findByKey((String)valueTypeMap.get(attribute.getValueType())));
            }
        }
    }

    private void generateAttributeUnitMap(RexsVersion version, RexsDatabaseModelFile rexsModel) {
        Map mapofVersion = this.attributeUnits.computeIfAbsent(version, k -> new HashMap());
        HashMap<BigInteger, String> unitMap = new HashMap<BigInteger, String>();
        if (rexsModel.getUnits() != null) {
            for (Unit unit : rexsModel.getUnits().getUnit()) {
                if (RexsStandardUnitIds.degree.getId().equals(unit.getName())) {
                    unitMap.put(unit.getId(), RexsStandardUnitIds.deg.getId());
                    continue;
                }
                unitMap.put(unit.getId(), unit.getName());
            }
        }
        if (rexsModel.getAttributes() != null) {
            for (Attribute attribute : rexsModel.getAttributes().getAttribute()) {
                String unit = (String)unitMap.get(attribute.getUnit());
                mapofVersion.put(attribute.getAttributeId(), RexsUnitId.findById(unit));
            }
        }
    }

    @Override
    public RexsUnitId getAttributeUnit(String rexsAttributeId, RexsVersion version) {
        Map<String, RexsUnitId> unitsMap = this.attributeUnits.get(version);
        if (unitsMap != null && unitsMap.containsKey(rexsAttributeId)) {
            return unitsMap.get(rexsAttributeId);
        }
        throw new IllegalArgumentException(String.format("Rexs Attribute with id %s is not registered in RexsVersion %s", rexsAttributeId, version.getName()));
    }

    @Override
    public RexsValueType getAttributeType(String rexsAttributeId, RexsVersion version) {
        Map<String, RexsValueType> map = this.attributeTypes.get(version);
        if (map != null && map.containsKey(rexsAttributeId)) {
            return map.get(rexsAttributeId);
        }
        throw new IllegalArgumentException(String.format("Rexs Attribute with id %s is not registered in RexsVersion %s", rexsAttributeId, version.getName()));
    }

    @Override
    public String getAttributeName(String attributeId, RexsVersion version) {
        if (!this.attributeMap.get(version).containsKey(attributeId)) {
            return attributeId;
        }
        Attribute attribute = this.attributeMap.get(version).get(attributeId);
        if (DbModelRegistry.getLanguageDefaultLocale().equals("de")) {
            return attribute.getNameDe();
        }
        return attribute.getNameEn();
    }

    @Override
    public String getAttributeSymbol(String attributeId, RexsVersion version) {
        if (!this.attributeMap.get(version).containsKey(attributeId)) {
            return "";
        }
        return this.attributeMap.get(version).get(attributeId).getSymbol();
    }

    @Override
    public String getNameForEnumValue(String attributeId, RexsVersion version, String value) {
        Attribute attribute = this.attributeMap.get(version).get(attributeId);
        for (EnumValue enumValue : attribute.getEnumValues().getEnumValue()) {
            if (!enumValue.getValue().equals(value)) continue;
            if (DbModelRegistry.getLanguageDefaultLocale().equals("de")) {
                return enumValue.getNameDe();
            }
            return enumValue.getNameEn();
        }
        return value;
    }

    private void generateAttributeComponentMappings(RexsVersion version, RexsDatabaseModelFile rexsModel) {
        Map attributeToComponentMapofVersion = this.attributeToComponentMap.computeIfAbsent(version, k -> new HashMap());
        Map componentToAttributeMapofVersion = this.componentToAttributesMap.computeIfAbsent(version, k -> new HashMap());
        if (rexsModel.getComponentAttributeMappings() != null) {
            for (ComponentAttributeMapping mapping : rexsModel.getComponentAttributeMappings().getComponentAttributeMapping()) {
                RexsComponentType componentType = RexsComponentType.findById(mapping.getComponentId());
                String attributeId = mapping.getAttributeId();
                List componentsOfAttributeList = attributeToComponentMapofVersion.computeIfAbsent(attributeId, k -> new ArrayList());
                List attributesOfComponentList = componentToAttributeMapofVersion.computeIfAbsent(componentType, k -> new ArrayList());
                componentsOfAttributeList.add(componentType);
                attributesOfComponentList.add(attributeId);
            }
        }
    }

    @Override
    public boolean componentAttributeMappingExists(String rexsAttributeId, RexsComponentType rexsCompType, RexsVersion version) {
        Map<String, List<RexsComponentType>> map = this.attributeToComponentMap.get(version);
        if (map != null && map.containsKey(rexsAttributeId)) {
            return map.get(rexsAttributeId).contains(rexsCompType);
        }
        return false;
    }

    @Override
    public List<RexsComponentType> getAvailableComponentTypesForAttributeId(String rexsAttributeId, RexsVersion version) {
        Map<String, List<RexsComponentType>> map = this.attributeToComponentMap.get(version);
        if (map != null && map.containsKey(rexsAttributeId)) {
            return map.get(rexsAttributeId);
        }
        throw new IllegalArgumentException(String.format("Rexs Attribute with id %s is not registered in RexsVersion %s", rexsAttributeId, version.getName()));
    }

    @Override
    public List<String> getAttributeIdsOfComponentType(RexsComponentType rexsComponentType, RexsVersion version) {
        Map<RexsComponentType, List<String>> map = this.componentToAttributesMap.get(version);
        if (map != null && map.containsKey(rexsComponentType)) {
            return map.get(rexsComponentType);
        }
        throw new IllegalArgumentException(String.format("Rexs component type %s is not registered in RexsVersion %s", rexsComponentType, version.getName()));
    }

    @Override
    public RexsVersion getVersion(String version) {
        return this.versions.get(version);
    }

    @Override
    public RexsComponentType getComponentType(RexsVersion version, String componentType) {
        Map<String, RexsComponentType> map = this.componentMap.get(version);
        if (map != null && map.containsKey(componentType)) {
            return map.get(componentType);
        }
        return RexsStandardComponentTypes.UNKNOWN;
    }

    @Override
    public boolean hasAttributeWithId(RexsVersion version, String attributeId) {
        Map<String, Attribute> map = this.attributeMap.get(version);
        return map != null && map.containsKey(attributeId);
    }

    private static String getLanguageDefaultLocale() {
        Locale locale = Locale.getDefault();
        if (!locale.getLanguage().equalsIgnoreCase("en") && !locale.getLanguage().equalsIgnoreCase("de")) {
            return Locale.ENGLISH.getLanguage();
        }
        return locale.getLanguage();
    }

    @Override
    public boolean hasRelationTypes(RexsVersion version) {
        Map<RexsRelationType, List<List<AllowedCombinationRole>>> relationsToAllowedCombinationsMapOfVersion = this.relationsToAllowedCombinationsMap.get(version);
        return relationsToAllowedCombinationsMapOfVersion != null && !relationsToAllowedCombinationsMapOfVersion.isEmpty();
    }

    @Override
    public List<List<AllowedCombinationRole>> getAllowedCombinationsForRelation(RexsVersion version, RexsRelationType relationType) {
        Map<RexsRelationType, List<List<AllowedCombinationRole>>> relationsToAllowedCombinationsMapOfVersion = this.relationsToAllowedCombinationsMap.get(version);
        if (relationsToAllowedCombinationsMapOfVersion == null) {
            throw new IllegalArgumentException(String.format("No relation types for REXS version %s specified", version.getName()));
        }
        List<List<AllowedCombinationRole>> listOfAllowedCombinations = relationsToAllowedCombinationsMapOfVersion.get(relationType);
        if (listOfAllowedCombinations == null || listOfAllowedCombinations.isEmpty()) {
            throw new IllegalArgumentException(String.format("Rexs Relation type %s is not defined in version %s", relationType, version.getName()));
        }
        return listOfAllowedCombinations;
    }
}

