/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.db;

import info.rexs.db.DbModelFile;
import info.rexs.db.constants.RexsVersion;
import info.rexs.db.jaxb.RexsDatabaseModelFile;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class DbModelResolver {
    private static DbModelResolver instance = null;
    private Map<DbModelFile, RexsDatabaseModelFile> dbModelFileCache = new HashMap<DbModelFile, RexsDatabaseModelFile>();

    private DbModelResolver() {
    }

    public static synchronized DbModelResolver getInstance() {
        if (instance == null) {
            instance = new DbModelResolver();
        }
        return instance;
    }

    public RexsDatabaseModelFile resolve(RexsVersion version) {
        DbModelFile dbModelFile = DbModelFile.findByVersion(version);
        if (dbModelFile == null) {
            return null;
        }
        if (this.dbModelFileCache.containsKey(dbModelFile)) {
            return this.dbModelFileCache.get(dbModelFile);
        }
        RexsDatabaseModelFile dbModel = null;
        try (InputStream input = dbModelFile.openInputStream();){
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{RexsDatabaseModelFile.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            dbModel = (RexsDatabaseModelFile)unmarshaller.unmarshal(input);
        }
        catch (Exception ex) {
            throw new IllegalStateException(String.format("could not load rexs db model for version %s", dbModelFile.getVersion()), ex);
        }
        this.dbModelFileCache.put(dbModelFile, dbModel);
        return dbModel;
    }
}

