/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.db.constants;

import info.rexs.db.constants.standard.RexsStandardRelationRoles;
import java.util.HashMap;
import java.util.Map;

public class RexsRelationRole
implements RexsStandardRelationRoles {
    private static Map<String, RexsRelationRole> allRelationRoles = new HashMap<String, RexsRelationRole>();
    private final String key;

    private RexsRelationRole(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("key cannot be empty");
        }
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isOneOf(RexsRelationRole ... checkRelationRoles) {
        if (checkRelationRoles == null) {
            return false;
        }
        for (RexsRelationRole checkRelationRole : checkRelationRoles) {
            if (!this.equals(checkRelationRole)) continue;
            return true;
        }
        return false;
    }

    public static RexsRelationRole create(String key) {
        RexsRelationRole relationRole = new RexsRelationRole(key);
        allRelationRoles.put(key, relationRole);
        return relationRole;
    }

    public static RexsRelationRole findByKey(String key) {
        if (key == null) {
            return null;
        }
        RexsStandardRelationRoles.init();
        return allRelationRoles.getOrDefault(key, null);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RexsRelationRole)) {
            return false;
        }
        RexsRelationRole other = (RexsRelationRole)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this_key = this.getKey();
        String other_key = other.getKey();
        return this_key == null ? other_key == null : this_key.equals(other_key);
    }

    protected boolean canEqual(Object other) {
        return other instanceof RexsRelationRole;
    }

    public int hashCode() {
        int result = 1;
        String _key = this.getKey();
        result = result * 59 + (_key == null ? 43 : _key.hashCode());
        return result;
    }
}

