/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.db.constants;

import info.rexs.db.constants.standard.RexsStandardUnitIds;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RexsUnitId
implements RexsStandardUnitIds {
    private static final Map<String, RexsUnitId> allUnitIds = new HashMap<String, RexsUnitId>();
    private final String id;
    private int numericId = 0;

    private RexsUnitId(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("id cannot be empty");
        }
        this.id = id;
    }

    private RexsUnitId(String id, int numericId) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("id cannot be empty");
        }
        if (numericId < 0) {
            throw new IllegalArgumentException("numericId cannot be negative");
        }
        this.id = id;
        this.numericId = numericId;
    }

    public String getId() {
        return this.id;
    }

    public int getNumericId() {
        return this.numericId;
    }

    public boolean isOneOf(RexsUnitId ... checkUnitIds) {
        if (checkUnitIds == null) {
            return false;
        }
        for (RexsUnitId checkUnitId : checkUnitIds) {
            if (!this.equals(checkUnitId)) continue;
            return true;
        }
        return false;
    }

    public static RexsUnitId create(String id) {
        RexsUnitId unitId = new RexsUnitId(id);
        allUnitIds.put(id, unitId);
        return unitId;
    }

    public static RexsUnitId create(String id, int numericId) {
        if (numericId == 0) {
            return RexsUnitId.create(id);
        }
        RexsUnitId unitId = new RexsUnitId(id, numericId);
        for (RexsUnitId unit : allUnitIds.values()) {
            if (unit.numericId != numericId) continue;
            throw new IllegalArgumentException("numericId already exists");
        }
        allUnitIds.put(id, unitId);
        return unitId;
    }

    public static RexsUnitId findById(String id) {
        if (id == null) {
            return null;
        }
        if (id.isEmpty()) {
            return RexsStandardUnitIds.none;
        }
        RexsStandardUnitIds.init();
        return allUnitIds.getOrDefault(id, UNKNOWN);
    }

    public static RexsUnitId findById(int numericId) {
        RexsStandardUnitIds.init();
        for (RexsUnitId unit : allUnitIds.values()) {
            if (unit.numericId != numericId) continue;
            return unit;
        }
        return UNKNOWN;
    }

    public boolean isEquivalent(RexsUnitId unit) {
        if (unit == null) {
            return false;
        }
        for (Set equivalentUnit : EQUIVALENT_UNITS) {
            if (!equivalentUnit.contains(this) || !equivalentUnit.contains(unit)) continue;
            return true;
        }
        return false;
    }
}

