/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.model;

import info.rexs.db.constants.RexsComponentType;
import info.rexs.db.constants.RexsRelationRole;
import info.rexs.db.constants.RexsRelationType;
import info.rexs.db.constants.RexsVersion;
import info.rexs.db.constants.standard.RexsStandardAttributeIds;
import info.rexs.db.constants.standard.RexsStandardComponentTypes;
import info.rexs.db.constants.standard.RexsStandardRelationRoles;
import info.rexs.db.constants.standard.RexsStandardRelationTypes;
import info.rexs.model.RexsAttribute;
import info.rexs.model.RexsComponent;
import info.rexs.model.RexsLoadSpectrum;
import info.rexs.model.RexsModelAccessException;
import info.rexs.model.RexsModelObjectFactory;
import info.rexs.model.RexsRelation;
import info.rexs.model.RexsRelationRef;
import info.rexs.model.RexsSubModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;

public class RexsModel {
    private RexsVersion version;
    private String originVersion;
    private String applicationId;
    private String applicationVersion;
    protected List<RexsRelation> relations = new ArrayList<RexsRelation>();
    protected List<RexsLoadSpectrum> loadSpectrums = new ArrayList<RexsLoadSpectrum>();
    private Map<Integer, RexsComponent> components = new HashMap<Integer, RexsComponent>();
    private Map<RexsComponentType, List<RexsComponent>> mapTypeToComponent = new HashMap<RexsComponentType, List<RexsComponent>>();
    private Map<Integer, List<RexsRelation>> mapMainCompToRelation = new HashMap<Integer, List<RexsRelation>>();
    private Map<RexsRelationType, List<RexsRelation>> mapTypeToRelation = new HashMap<RexsRelationType, List<RexsRelation>>();

    public RexsModel(String version, String applicationId, String applicationVersion) {
        this.version = RexsVersion.findByName(version);
        this.originVersion = version;
        this.applicationId = applicationId;
        this.applicationVersion = applicationVersion;
    }

    public RexsModel(RexsModel model) {
        this.version = model.getVersion();
        this.originVersion = model.getOriginVersion();
        this.applicationId = model.applicationId;
        this.applicationVersion = model.applicationVersion;
        for (RexsRelation relation : model.getRelations()) {
            RexsRelation newRelation = new RexsRelation(relation);
            this.addRelation(newRelation);
        }
        for (RexsComponent component : model.getComponents()) {
            RexsComponent newComponent = new RexsComponent(component);
            this.addComponent(newComponent);
        }
    }

    protected RexsModel(RexsVersion version, String applicationId, String applicationVersion) {
        this.version = version;
        this.originVersion = version.getName();
        this.applicationId = applicationId;
        this.applicationVersion = applicationVersion;
    }

    public RexsVersion getVersion() {
        return this.version;
    }

    public void setVersion(RexsVersion version) {
        this.version = version;
    }

    public String getOriginVersion() {
        return this.originVersion;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public List<RexsComponent> getComponents() {
        return this.components.values().stream().collect(Collectors.toList());
    }

    public List<RexsComponent> getComponentsSorted() {
        return this.components.keySet().stream().sorted().map(id -> this.getComponent((Integer)id)).collect(Collectors.toList());
    }

    public List<RexsRelation> getRelations() {
        return this.relations;
    }

    public List<RexsLoadSpectrum> getLoadSpectrums() {
        return this.loadSpectrums;
    }

    public void addLoadSpectrum(RexsLoadSpectrum loadSpectrum) {
        this.loadSpectrums.add(loadSpectrum);
    }

    public boolean hasComponent(Integer compId) {
        return this.components.containsKey(compId);
    }

    public RexsComponent getComponent(Integer compId) {
        return this.components.get(compId);
    }

    public List<RexsRelation> getRelationsOfMainComp(Integer mainCompId) {
        return this.mapMainCompToRelation.getOrDefault(mainCompId, new ArrayList());
    }

    public List<RexsRelation> getRelationsOfType(RexsRelationType type) {
        return this.mapTypeToRelation.getOrDefault(type, new ArrayList());
    }

    public List<RexsRelation> getRelations(RexsRelationType type, RexsRelationRole role, int component) {
        return this.relations.stream().filter(rel -> rel.getType() == type && rel.findComponentIdByRole(role) == component).toList();
    }

    public List<RexsComponent> getComponentsOfType(RexsComponentType componentType) {
        return this.mapTypeToComponent.getOrDefault(componentType, new ArrayList());
    }

    public int getOrderOfAssemblyRelationOf(Integer compId) {
        List<RexsRelation> orderedAssemblyRelations = this.getRelationsOfType(RexsStandardRelationTypes.ordered_assembly);
        for (RexsRelation relation : orderedAssemblyRelations) {
            if (!relation.hasComponent(compId) || !relation.findRoleByComponentId(compId).equals(RexsStandardRelationRoles.part)) continue;
            return relation.getOrder();
        }
        return -1;
    }

    public int getOrderOfReferenceRelationOf(Integer compId) {
        List<RexsRelation> orderedReferenceRelations = this.getRelationsOfType(RexsStandardRelationTypes.ordered_reference);
        for (RexsRelation relation : orderedReferenceRelations) {
            if (!relation.hasComponent(compId) || !relation.findRoleByComponentId(compId).equals(RexsStandardRelationRoles.referenced)) continue;
            return relation.getOrder();
        }
        return -1;
    }

    public RexsRelation findFirstRelation(Integer compId, RexsRelationRole role) {
        for (RexsRelation relaltion : this.relations) {
            if (!relaltion.hasComponent(compId) || !role.equals(relaltion.findRoleByComponentId(compId))) continue;
            return relaltion;
        }
        return null;
    }

    public RexsRelation getStageRelationFromStageId(Integer stageId) {
        for (RexsRelation relation : this.getRelationsOfMainComp(stageId)) {
            if (!relation.getType().equals(RexsStandardRelationTypes.stage)) continue;
            return relation;
        }
        return null;
    }

    public RexsComponent getGear1OfStage(Integer stageId) {
        RexsRelation stageRel = this.getStageRelationFromStageId(stageId);
        return this.getComponent(stageRel.findComponentIdByRole(RexsStandardRelationRoles.gear_1));
    }

    public RexsComponent getGear2OfStage(Integer stageId) {
        RexsRelation stageRel = this.getStageRelationFromStageId(stageId);
        return this.getComponent(stageRel.findComponentIdByRole(RexsStandardRelationRoles.gear_2));
    }

    public List<RexsComponent> getSubComponentsWithType(Integer mainCompId, RexsComponentType type) {
        RexsComponent mainComp = this.getComponent(mainCompId);
        if (mainComp.getType().equals(type)) {
            return Arrays.asList(mainComp);
        }
        List<RexsComponent> subCompList = this.getChildrenWithType(mainCompId, type);
        if (subCompList.isEmpty()) {
            subCompList = this.getGrandChildrenWithType(mainCompId, type);
        }
        return subCompList;
    }

    public List<RexsComponent> getChildrenWithType(Integer mainCompId, RexsComponentType type) {
        HashSet<RexsComponent> childrenWithType = new HashSet<RexsComponent>();
        for (RexsRelation relation : this.getRelationsOfMainComp(mainCompId)) {
            for (Integer subCompId : relation.getSubComponentIds()) {
                RexsComponent subComp = this.getComponent(subCompId);
                if (!subComp.getType().equals(type)) continue;
                childrenWithType.add(subComp);
            }
        }
        if (type == RexsStandardComponentTypes.stage_gear_data) {
            childrenWithType.addAll(this.getAssociatedStageGearDataComponents(mainCompId));
        }
        return childrenWithType.stream().sorted().collect(Collectors.toList());
    }

    private List<RexsComponent> getGrandChildrenWithType(Integer mainCompId, RexsComponentType type) {
        HashSet<RexsComponent> grandChildrenWithType = new HashSet<RexsComponent>();
        for (RexsRelation relation : this.getRelationsOfMainComp(mainCompId)) {
            for (Integer subCompId : relation.getSubComponentIds()) {
                grandChildrenWithType.addAll(this.getChildrenWithType(subCompId, type));
            }
        }
        return new ArrayList<RexsComponent>(grandChildrenWithType);
    }

    public Set<RexsComponent> getAssociatedStageGearDataComponents(Integer compId) {
        HashSet<RexsComponent> stageGearDataComps = new HashSet<RexsComponent>();
        for (RexsRelation relation : this.getRelationsOfType(RexsStandardRelationTypes.stage_gear_data)) {
            if (!relation.hasComponent(compId)) continue;
            Integer stageGearDataId = relation.findComponentIdByRole(RexsStandardRelationRoles.stage_gear_data);
            RexsComponent stageGearData = this.getComponent(stageGearDataId);
            stageGearDataComps.add(stageGearData);
        }
        return stageGearDataComps;
    }

    public RexsComponent getStageFromStageGearData(Integer stageGearDataId) {
        for (RexsRelation relation : this.getRelationsOfType(RexsStandardRelationTypes.stage_gear_data)) {
            if (!relation.hasComponent(stageGearDataId)) continue;
            Integer stageId = relation.findComponentIdByRole(RexsStandardRelationRoles.stage);
            return this.getComponent(stageId);
        }
        return null;
    }

    public RexsComponent getGearFromStageGearData(RexsComponent stageGearData) {
        for (RexsRelation relation : this.getRelationsOfType(RexsStandardRelationTypes.stage_gear_data)) {
            if (!relation.hasComponent(stageGearData.getId())) continue;
            Integer gearId = relation.findComponentIdByRole(RexsStandardRelationRoles.gear);
            return this.getComponent(gearId);
        }
        return null;
    }

    public RexsComponent getStageGearData(Integer stageId, Integer gearId) {
        for (RexsRelation relation : this.getRelationsOfType(RexsStandardRelationTypes.stage_gear_data)) {
            if (!relation.hasComponent(stageId) || !relation.hasComponent(gearId)) continue;
            Integer stageGearDataId = relation.findComponentIdByRole(RexsStandardRelationRoles.stage_gear_data);
            return this.getComponent(stageGearDataId);
        }
        return null;
    }

    public RexsComponent getBearingRowWithOrder(RexsComponent bearing, int order) {
        List<RexsComponent> subComps = this.getSubComponentsWithType(bearing.getId(), RexsStandardComponentTypes.rolling_bearing_row);
        for (RexsComponent row : subComps) {
            int orderOfRow = this.getOrderOfAssemblyRelationOf(row.getId());
            if (order != orderOfRow) continue;
            return row;
        }
        String message = "No bearing row with desired order found for bearing " + bearing.getName() + " with Id " + bearing.getId();
        throw new RexsModelAccessException(message);
    }

    public List<RexsComponent> getFlankGeometriesOfStage(Integer stageId) {
        ArrayList<RexsComponent> compList = new ArrayList<RexsComponent>();
        RexsRelation stageRel = this.getStageRelationFromStageId(stageId);
        Integer gear1Id = stageRel.findComponentIdByRole(RexsStandardRelationRoles.gear_1);
        Integer gear2Id = stageRel.findComponentIdByRole(RexsStandardRelationRoles.gear_2);
        compList.add(this.getFlankGeometry(gear1Id, RexsStandardRelationRoles.left.getKey()));
        compList.add(this.getFlankGeometry(gear1Id, RexsStandardRelationRoles.right.getKey()));
        compList.add(this.getFlankGeometry(gear2Id, RexsStandardRelationRoles.left.getKey()));
        compList.add(this.getFlankGeometry(gear2Id, RexsStandardRelationRoles.right.getKey()));
        return compList;
    }

    public RexsComponent getFlankGeometry(Integer gearId, String flank) {
        RexsComponent flankGeometry = null;
        for (RexsRelation relation : this.getRelationsOfMainComp(gearId)) {
            if (!relation.getType().equals(RexsStandardRelationTypes.flank)) continue;
            RexsRelationRole role = RexsRelationRole.findByKey(flank);
            Integer flankId = relation.findComponentIdByRole(role);
            flankGeometry = this.getComponent(flankId);
            break;
        }
        return flankGeometry;
    }

    public RexsComponent getGearUnit() {
        List<RexsComponent> listOfGearUnits = this.getComponentsOfType(RexsComponentType.gear_unit);
        if (listOfGearUnits.size() != 1) {
            throw new RexsModelAccessException("there has to be exactly one gear_unit component in the model!");
        }
        return listOfGearUnits.get(0);
    }

    public RexsComponent getMaterial(RexsComponent componentWithMaterial) {
        List<RexsComponent> materials = this.getSubComponentsWithType(componentWithMaterial.getId(), RexsStandardComponentTypes.material);
        if (materials == null || materials.isEmpty()) {
            return null;
        }
        return materials.get(0);
    }

    public RexsComponent getLubricant(RexsComponent componentWithLubricant) {
        List<RexsComponent> lubricants = this.getSubComponentsWithType(componentWithLubricant.getId(), RexsStandardComponentTypes.lubricant);
        if (lubricants == null || lubricants.isEmpty()) {
            return null;
        }
        return lubricants.get(0);
    }

    public RexsComponent createComponent(RexsComponentType type, Integer id, String name) {
        if (this.components.containsKey(id)) {
            throw new RexsModelAccessException("component with id " + id + " already exists");
        }
        RexsComponent rexsComponent = RexsModelObjectFactory.getInstance().createRexsComponent(id, type, name);
        this.addComponent(rexsComponent);
        return rexsComponent;
    }

    public void addComponent(RexsComponent component) {
        this.components.put(component.getId(), component);
        ArrayList<RexsComponent> componentsForType = this.mapTypeToComponent.containsKey(component.getType()) ? this.mapTypeToComponent.get(component.getType()) : new ArrayList<RexsComponent>();
        componentsForType.add(component);
        this.mapTypeToComponent.put(component.getType(), componentsForType);
    }

    public RexsComponent createComponent(RexsComponentType type, String name) {
        Integer id = this.getNextFreeComponentId();
        return this.createComponent(type, id, name);
    }

    public boolean addCouplingRelation(RexsComponent relComp, RexsComponent firstPart, RexsComponent secondPart) {
        if (!this.componentsExists(relComp, firstPart, secondPart)) {
            return false;
        }
        RexsRelation relation = this.createRelation(RexsStandardRelationTypes.coupling, null);
        relation.addRef(this.createRelationRef(relComp, RexsStandardRelationRoles.assembly));
        relation.addRef(this.createRelationRef(firstPart, RexsStandardRelationRoles.side_1));
        relation.addRef(this.createRelationRef(secondPart, RexsStandardRelationRoles.side_2));
        this.addRelation(relation);
        return true;
    }

    public boolean addSideRelation(RexsComponent relComp, RexsComponent innerPart, RexsComponent outerPart) {
        if (!this.componentsExists(relComp, innerPart, outerPart)) {
            return false;
        }
        RexsRelation relation = this.createRelation(RexsStandardRelationTypes.side, null);
        relation.addRef(this.createRelationRef(relComp, RexsStandardRelationRoles.assembly));
        relation.addRef(this.createRelationRef(innerPart, RexsStandardRelationRoles.inner_part));
        relation.addRef(this.createRelationRef(outerPart, RexsStandardRelationRoles.outer_part));
        this.addRelation(relation);
        return true;
    }

    public boolean addConnectionRelation(RexsComponent side1, RexsComponent side2) {
        if (!this.componentsExists(side1, side2)) {
            return false;
        }
        RexsRelation relation = this.createRelation(RexsStandardRelationTypes.connection, null);
        relation.addRef(this.createRelationRef(side1, RexsStandardRelationRoles.side_1));
        relation.addRef(this.createRelationRef(side2, RexsStandardRelationRoles.side_2));
        this.addRelation(relation);
        return true;
    }

    public boolean addStageRelation(RexsComponent stage, RexsComponent gear1, RexsComponent gear2) {
        if (!this.componentsExists(stage, gear1, gear2)) {
            return false;
        }
        RexsRelation relation = this.createRelation(RexsStandardRelationTypes.stage, null);
        relation.addRef(this.createRelationRef(stage, RexsStandardRelationRoles.stage));
        relation.addRef(this.createRelationRef(gear1, RexsStandardRelationRoles.gear_1));
        relation.addRef(this.createRelationRef(gear2, RexsStandardRelationRoles.gear_2));
        this.addRelation(relation);
        return true;
    }

    public boolean addStageGearDataRelation(RexsComponent stage, RexsComponent gear, RexsComponent stageGearData) {
        if (!this.componentsExists(stage, gear, stageGearData)) {
            return false;
        }
        RexsRelation relation = this.createRelation(RexsStandardRelationTypes.stage_gear_data, null);
        relation.addRef(this.createRelationRef(stage, RexsStandardRelationRoles.stage));
        relation.addRef(this.createRelationRef(gear, RexsStandardRelationRoles.gear));
        relation.addRef(this.createRelationRef(stageGearData, RexsStandardRelationRoles.stage_gear_data));
        this.addRelation(relation);
        return true;
    }

    public boolean addAssemblyRelation(RexsComponent mainComp, RexsComponent partComp) {
        if (!this.componentsExists(mainComp, partComp)) {
            return false;
        }
        RexsRelation relation = this.createRelation(RexsStandardRelationTypes.assembly, null);
        relation.addRef(this.createRelationRef(mainComp, RexsStandardRelationRoles.assembly));
        relation.addRef(this.createRelationRef(partComp, RexsStandardRelationRoles.part));
        this.addRelation(relation);
        return true;
    }

    public boolean addReferenceRelation(RexsComponent mainComp, RexsComponent referenced) {
        if (!this.componentsExists(mainComp, referenced)) {
            return false;
        }
        RexsRelation relation = this.createRelation(RexsStandardRelationTypes.reference, null);
        relation.addRef(this.createRelationRef(mainComp, RexsStandardRelationRoles.origin));
        relation.addRef(this.createRelationRef(referenced, RexsStandardRelationRoles.referenced));
        this.addRelation(relation);
        return true;
    }

    public boolean addOrderedReferenceRelation(RexsComponent mainComp, RexsComponent referenced, int order) {
        if (!this.componentsExists(mainComp, referenced)) {
            return false;
        }
        RexsRelation relation = this.createRelation(RexsStandardRelationTypes.ordered_reference, order);
        relation.addRef(this.createRelationRef(mainComp, RexsStandardRelationRoles.origin));
        relation.addRef(this.createRelationRef(referenced, RexsStandardRelationRoles.referenced));
        this.addRelation(relation);
        return true;
    }

    public boolean addPlanetPinRelation(RexsComponent planetaryStage, RexsComponent planetPinShaft) {
        if (!this.componentsExists(planetaryStage, planetPinShaft)) {
            return false;
        }
        RexsRelation relation = this.createRelation(RexsStandardRelationTypes.planet_pin, null);
        relation.addRef(this.createRelationRef(planetaryStage, RexsStandardRelationRoles.planetary_stage));
        relation.addRef(this.createRelationRef(planetPinShaft, RexsStandardRelationRoles.shaft));
        this.addRelation(relation);
        return true;
    }

    public boolean addFlankRelation(RexsComponent gear, RexsComponent flank1, RexsComponent flank2) {
        if (!this.componentsExists(gear, flank1, flank2)) {
            return false;
        }
        RexsRelation relation = this.createRelation(RexsStandardRelationTypes.flank, null);
        relation.addRef(this.createRelationRef(gear, RexsStandardRelationRoles.gear));
        relation.addRef(this.createRelationRef(flank1, RexsStandardRelationRoles.left));
        relation.addRef(this.createRelationRef(flank2, RexsStandardRelationRoles.right));
        this.addRelation(relation);
        return true;
    }

    public boolean addOrderedAssemblyRelation(RexsComponent mainComp, RexsComponent partComp, int order) {
        if (!this.componentsExists(mainComp, partComp)) {
            return false;
        }
        RexsRelation relation = this.createRelation(RexsStandardRelationTypes.ordered_assembly, order);
        relation.addRef(this.createRelationRef(mainComp, RexsStandardRelationRoles.assembly));
        relation.addRef(this.createRelationRef(partComp, RexsStandardRelationRoles.part));
        this.addRelation(relation);
        return true;
    }

    public boolean addManufacturingStepRelation(RexsComponent flank, RexsComponent tool, RexsComponent manufacturingStep, int order) {
        if (!this.componentsExists(flank, tool, manufacturingStep)) {
            return false;
        }
        RexsRelation relation = this.createRelation(RexsStandardRelationTypes.manufacturing_step, order);
        relation.addRef(this.createRelationRef(flank, RexsStandardRelationRoles.workpiece));
        relation.addRef(this.createRelationRef(tool, RexsStandardRelationRoles.tool));
        relation.addRef(this.createRelationRef(manufacturingStep, RexsStandardRelationRoles.manufacturing_settings));
        this.addRelation(relation);
        return true;
    }

    private RexsRelation createRelation(RexsRelationType type, Integer order) {
        Integer id = this.getNextFreeRelationId();
        return RexsModelObjectFactory.getInstance().createRexsRelation(id, type, order);
    }

    private RexsRelationRef createRelationRef(RexsComponent component, RexsRelationRole role) {
        return RexsModelObjectFactory.getInstance().createRexsRelationRef(component.getId(), role, component.getType().getId());
    }

    public void addRelation(RexsRelation relation) {
        this.relations.add(relation);
        List relationsForType = this.mapTypeToRelation.getOrDefault(relation.getType(), new ArrayList());
        relationsForType.add(relation);
        this.mapTypeToRelation.put(relation.getType(), relationsForType);
        List relationsForMainComp = this.mapMainCompToRelation.getOrDefault(relation.getMainComponentId(), new ArrayList());
        relationsForMainComp.add(relation);
        this.mapMainCompToRelation.put(relation.getMainComponentId(), relationsForMainComp);
    }

    protected boolean componentsExists(RexsComponent ... rexsComponents) {
        if (rexsComponents == null) {
            return false;
        }
        for (RexsComponent rexsComponent : rexsComponents) {
            if (this.hasComponent(rexsComponent.getId())) continue;
            return false;
        }
        return true;
    }

    public void createLoadSpectrum() {
        if (!this.loadSpectrums.isEmpty()) {
            throw new RexsModelAccessException("Rexs specification allows only one load spectrum per rexs model!");
        }
        this.loadSpectrums.add(RexsModelObjectFactory.getInstance().createRexsLoadSpectrum(1));
    }

    public RexsSubModel createLoadCase(int idOfLoadCase) {
        if (this.loadSpectrums.isEmpty()) {
            this.createLoadSpectrum();
        } else if (this.getLoadCases().stream().anyMatch(lc -> lc.getId() == idOfLoadCase)) {
            throw new RexsModelAccessException("Load case with this id already exists!");
        }
        RexsLoadSpectrum spectrum = this.loadSpectrums.get(0);
        RexsSubModel loadCase = RexsModelObjectFactory.getInstance().createRexsSubModel(idOfLoadCase);
        spectrum.addLoadCase(loadCase);
        return loadCase;
    }

    public boolean isPlanetPin(RexsComponent rexsComponent) {
        for (RexsRelation planetPinRel : this.getRelationsOfType(RexsStandardRelationTypes.planet_pin)) {
            Integer shaftId = planetPinRel.findComponentIdByRole(RexsStandardRelationRoles.shaft);
            if (!rexsComponent.getId().equals(shaftId)) continue;
            return true;
        }
        return false;
    }

    public boolean isPlanetShaft(RexsComponent rexsComponent) {
        for (RexsRelation planetShaftRel : this.getRelationsOfType(RexsStandardRelationTypes.planet_shaft)) {
            Integer shaftId = planetShaftRel.findComponentIdByRole(RexsStandardRelationRoles.shaft);
            if (!rexsComponent.getId().equals(shaftId)) continue;
            return true;
        }
        return false;
    }

    public boolean isPartOfPlanetaryStage(RexsComponent rexsComponent) {
        Integer componentId = rexsComponent.getId();
        RexsComponentType componentType = rexsComponent.getType();
        if (RexsStandardComponentTypes.cylindrical_stage.getId().equals(componentType.getId()) || RexsStandardComponentTypes.shaft.getId().equals(componentType.getId())) {
            for (RexsComponent planetaryStage : this.getComponentsOfType(RexsStandardComponentTypes.planetary_stage)) {
                for (RexsRelation relation : this.getRelationsOfMainComp(planetaryStage.getId())) {
                    if (!componentId.equals(relation.findComponentIdByRole(RexsStandardRelationRoles.part))) continue;
                    return true;
                }
            }
            return false;
        }
        if (RexsStandardComponentTypes.cylindrical_gear.getId().equals(componentType.getId()) || RexsStandardComponentTypes.ring_gear.getId().equals(componentType.getId())) {
            for (RexsComponent stage : this.getStagesOfGear(rexsComponent)) {
                if (!this.isPartOfPlanetaryStage(stage)) continue;
                return true;
            }
            return false;
        }
        if (RexsStandardComponentTypes.side_plate.getId().equals(componentType.getId()) || RexsStandardComponentTypes.planet_carrier.getId().equals(componentType.getId())) {
            return true;
        }
        if (RexsStandardComponentTypes.concept_bearing.getId().equals(componentType.getId()) || RexsStandardComponentTypes.coupling.getId().equals(componentType.getId()) || RexsStandardComponentTypes.rolling_bearing_with_catalog_geometry.getId().equals(componentType.getId()) || RexsStandardComponentTypes.rolling_bearing_with_detailed_geometry.getId().equals(componentType.getId())) {
            for (RexsRelation relation : this.getRelationsOfMainComp(rexsComponent.getId())) {
                if (relation.getType() == RexsStandardRelationTypes.side) {
                    RexsComponent sideComp1 = this.getComponent(relation.findComponentIdByRole(RexsStandardRelationRoles.side_1));
                    RexsComponent sideComp2 = this.getComponent(relation.findComponentIdByRole(RexsStandardRelationRoles.side_2));
                    if (!this.isPartOfPlanetaryStage(sideComp1) || !this.isPartOfPlanetaryStage(sideComp2)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public List<RexsComponent> getStagesOfGear(RexsComponent gear) {
        RexsComponentType gearType = gear.getType();
        RexsComponentType stageType = null;
        if (RexsStandardComponentTypes.cylindrical_gear.getId().equals(gearType.getId()) || RexsStandardComponentTypes.ring_gear.getId().equals(gearType.getId())) {
            stageType = RexsStandardComponentTypes.cylindrical_stage;
        } else if (RexsStandardComponentTypes.bevel_gear.getId().equals(gearType.getId())) {
            stageType = RexsStandardComponentTypes.bevel_stage;
        } else if (RexsStandardComponentTypes.worm_gear.getId().equals(gearType.getId()) || RexsStandardComponentTypes.worm_wheel.getId().equals(gearType.getId())) {
            stageType = RexsStandardComponentTypes.worm_stage;
        } else if (RexsStandardComponentTypes.involute_spline_gear_shaft.getId().equals(gearType.getId()) || RexsStandardComponentTypes.involute_spline_gear_hub.getId().equals(gearType.getId())) {
            stageType = RexsStandardComponentTypes.involute_spline_connection;
        }
        if (stageType == null) {
            return new ArrayList<RexsComponent>();
        }
        ArrayList<RexsComponent> stages = new ArrayList<RexsComponent>();
        for (RexsComponent stage : this.getComponentsOfType(stageType)) {
            if (!this.getSubComponentsWithType(stage.getId(), gear.getType()).contains(gear)) continue;
            stages.add(stage);
        }
        return stages;
    }

    public RexsComponent getParent(Integer subCompId, RexsComponentType typeOfParent) {
        RexsComponent parent = null;
        for (RexsComponent potentialParent : this.getComponentsOfType(typeOfParent)) {
            for (RexsRelation relation : this.getRelationsOfMainComp(potentialParent.getId())) {
                if (!relation.getType().equals(RexsStandardRelationTypes.assembly) || !subCompId.equals(relation.findComponentIdByRole(RexsStandardRelationRoles.part))) continue;
                if (parent == null) {
                    parent = potentialParent;
                    continue;
                }
                return null;
            }
        }
        return parent;
    }

    public boolean hasParentOfType(Integer subCompId, RexsComponentType typeOfParent) {
        return this.getParent(subCompId, typeOfParent) != null;
    }

    public Integer getNextFreeComponentId() {
        OptionalInt max = this.components.keySet().stream().mapToInt(Integer::intValue).max();
        if (max.isPresent()) {
            return max.getAsInt() + 1;
        }
        return 1;
    }

    private Integer getNextFreeRelationId() {
        OptionalInt max = this.relations.stream().mapToInt(relation -> relation.getId()).max();
        if (max.isPresent()) {
            return max.getAsInt() + 1;
        }
        return 1;
    }

    public RexsComponent getFinishingToolOfGear(RexsComponent gear) {
        List<RexsRelation> relationsOfGear = this.getRelationsOfMainComp(gear.getId());
        int highestOrder = 0;
        RexsComponent finishingTool = null;
        for (RexsRelation relation : relationsOfGear) {
            int order;
            if (relation.getType() != RexsStandardRelationTypes.ordered_reference || (order = relation.getOrder().intValue()) < highestOrder) continue;
            highestOrder = order;
            finishingTool = this.getComponent(relation.findComponentIdByRole(RexsStandardRelationRoles.referenced));
        }
        return finishingTool;
    }

    public RexsComponent getShaftOfGear(RexsComponent gear) {
        return this.getParent(gear.getId(), RexsStandardComponentTypes.shaft);
    }

    public List<RexsSubModel> getLoadCases() {
        if (this.loadSpectrums.isEmpty()) {
            return new ArrayList<RexsSubModel>();
        }
        List<RexsSubModel> loadCases = this.loadSpectrums.get(0).getLoadCases();
        Collections.sort(loadCases);
        return loadCases;
    }

    public RexsSubModel getAccumulation() {
        if (this.loadSpectrums.isEmpty()) {
            return RexsModelObjectFactory.getInstance().createRexsSubModel();
        }
        return this.loadSpectrums.get(0).getAccumulation();
    }

    public void changeComponentId(RexsComponent component, Integer newId) {
        Integer oldId = component.getId();
        component.changeComponentId(newId);
        this.components.remove(oldId);
        this.components.put(newId, component);
        for (RexsComponent comp : this.components.values()) {
            RexsAttribute refCompAttribute;
            if (!comp.hasAttribute(RexsStandardAttributeIds.reference_component_for_position) || Integer.valueOf((refCompAttribute = comp.getAttribute(RexsStandardAttributeIds.reference_component_for_position)).getStringValue()) != oldId) continue;
            refCompAttribute.setStringValue(String.valueOf(newId));
        }
        for (RexsRelation relation : this.relations) {
            if (!relation.hasComponent(oldId)) continue;
            relation.changeComponentId(oldId, newId);
        }
        List mainrelations = this.mapMainCompToRelation.getOrDefault(oldId, new ArrayList());
        this.mapMainCompToRelation.put(newId, mainrelations);
        this.mapMainCompToRelation.remove(oldId);
        for (RexsLoadSpectrum loadSpectrum : this.loadSpectrums) {
            for (RexsSubModel subModel : loadSpectrum.getLoadCases()) {
                subModel.changeComponentId(oldId, newId);
            }
            loadSpectrum.getAccumulation().changeComponentId(oldId, newId);
        }
    }

    public void changeComponentId(RexsComponent component) {
        this.changeComponentId(component, this.getNextFreeComponentId());
    }

    public void copyAttributesFromSubModelToMaster(RexsSubModel subModel) {
        for (RexsComponent masterComp : this.getComponents()) {
            if (!subModel.hasComponent(masterComp.getId())) continue;
            RexsComponent subModelComp = subModel.getComponent(masterComp.getId());
            for (RexsAttribute attribute : subModelComp.getAttributes()) {
                masterComp.addAttribute(attribute);
            }
        }
    }

    public void removeRelation(RexsRelation relation) {
        this.relations.remove(relation);
        this.mapMainCompToRelation.get(relation.getMainComponentId()).remove(relation);
        this.mapTypeToRelation.get(relation.getType()).remove(relation);
    }

    public void removeComponent(RexsComponent component) {
        List<RexsRelation> relationsOfComponent = this.relations.stream().filter(r -> r.hasComponent(component.getId())).toList();
        for (RexsRelation relation : relationsOfComponent) {
            this.removeRelation(relation);
        }
        this.components.remove(component.getId());
        List<RexsComponent> compsOfType = this.mapTypeToComponent.get(component.getType());
        compsOfType.remove(component);
        this.mapTypeToComponent.put(component.getType(), compsOfType);
    }
}

