/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.model;

import info.rexs.db.constants.RexsAttributeId;
import info.rexs.db.constants.RexsComponentType;
import info.rexs.db.constants.RexsRelationRole;
import info.rexs.db.constants.RexsRelationType;
import info.rexs.db.constants.RexsVersion;
import info.rexs.model.RexsAttribute;
import info.rexs.model.RexsComponent;
import info.rexs.model.RexsLoadSpectrum;
import info.rexs.model.RexsModel;
import info.rexs.model.RexsRelation;
import info.rexs.model.RexsRelationRef;
import info.rexs.model.RexsSubModel;

public class RexsModelObjectFactory {
    private static RexsModelObjectFactory instance = new RexsModelObjectFactory();

    public static void setInstance(RexsModelObjectFactory newInstance) {
        instance = newInstance;
    }

    public static RexsModelObjectFactory getInstance() {
        return instance;
    }

    public RexsModel createRexsModel(String version, String applicationId, String applicationVersion) {
        return new RexsModel(version, applicationId, applicationVersion);
    }

    public RexsModel createRexsModel(RexsVersion version, String applicationId, String applicationVersion) {
        return new RexsModel(version, applicationId, applicationVersion);
    }

    public RexsComponent createRexsComponent(Integer id, String type, String name) {
        return new RexsComponent(id, type, name);
    }

    public RexsComponent createRexsComponent(Integer id, RexsComponentType type, String name) {
        return new RexsComponent(id, type, name);
    }

    public RexsAttribute createRexsAttribute(String id, String unit) {
        return new RexsAttribute(id, unit);
    }

    public RexsAttribute createRexsAttribute(String id) {
        return new RexsAttribute(id);
    }

    public RexsAttribute createRexsAttribute(RexsAttributeId id) {
        return new RexsAttribute(id);
    }

    public RexsRelation createRexsRelation(Integer id, String type, Integer order) {
        return new RexsRelation(id, type, order);
    }

    public RexsRelation createRexsRelation(Integer id, RexsRelationType type, Integer order) {
        return new RexsRelation(id, type, order);
    }

    public RexsRelationRef createRexsRelationRef(Integer id, String role, String hint) {
        return new RexsRelationRef(id, role, hint);
    }

    public RexsRelationRef createRexsRelationRef(Integer id, RexsRelationRole role, String hint) {
        return new RexsRelationRef(id, role, hint);
    }

    public RexsLoadSpectrum createRexsLoadSpectrum(Integer id) {
        return new RexsLoadSpectrum(id);
    }

    public RexsSubModel createRexsSubModel(Integer id, boolean isAccumulation) {
        return new RexsSubModel(id, isAccumulation);
    }

    public RexsSubModel createRexsSubModel(Integer id) {
        return new RexsSubModel(id);
    }

    public RexsSubModel createRexsSubModel() {
        return new RexsSubModel();
    }

    public RexsAttribute copyAttribute(RexsAttribute attribute) {
        RexsAttribute copy;
        RexsAttribute rexsAttribute = copy = attribute.getOriginUnit() != null ? this.createRexsAttribute(attribute.getOriginAttributeId(), attribute.getOriginUnit()) : this.createRexsAttribute(attribute.getOriginAttributeId());
        if (attribute.hasValue()) {
            copy.setRawValue(attribute.getRawValue().copy());
        }
        return copy;
    }
}

