/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.upgrade;

import info.rexs.db.constants.RexsVersion;
import info.rexs.db.constants.standard.RexsStandardVersions;
import info.rexs.model.RexsModel;
import info.rexs.upgrade.RexsUpgradeException;
import info.rexs.upgrade.upgraders.ModelUpgrader;
import info.rexs.upgrade.upgraders.ModelUpgraderResult;
import info.rexs.upgrade.upgraders.UpgradeNotifications;
import info.rexs.upgrade.upgraders.UpgradeResolver;
import java.util.ArrayList;
import java.util.List;

public class RexsUpgrader {
    private RexsModel rexsModel;

    public RexsUpgrader(RexsModel rexsModel) {
        this.rexsModel = rexsModel;
    }

    public RexsModel getRexsModel() {
        return this.rexsModel;
    }

    public ModelUpgraderResult upgrade() throws RexsUpgradeException {
        return this.upgrade(RexsVersion.getLatest(), false);
    }

    public ModelUpgraderResult upgrade(RexsVersion toVersion, boolean strictMode) throws RexsUpgradeException {
        RexsVersion fromVersion = this.rexsModel.getVersion();
        if (fromVersion == null || fromVersion.equals(RexsStandardVersions.UNKNOWN)) {
            throw new RexsUpgradeException(String.format("unknown version %s", this.rexsModel.getVersion()));
        }
        ArrayList<UpgradeNotifications.Notification> notifications = new ArrayList<UpgradeNotifications.Notification>();
        RexsModel currentModel = this.rexsModel;
        List<ModelUpgrader> upgraders = UpgradeResolver.getInstance().resolve(fromVersion, toVersion);
        for (ModelUpgrader upgrader : upgraders) {
            ModelUpgraderResult result = upgrader.upgrade(currentModel, strictMode);
            currentModel = result.getModel();
            notifications.addAll(result.getNotifications().getNotifications());
        }
        UpgradeNotifications notifications2 = new UpgradeNotifications(notifications);
        return new ModelUpgraderResult(currentModel, notifications2);
    }
}

