/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.upgrade.upgraders;

import info.rexs.db.constants.RexsRelationRole;
import info.rexs.db.constants.standard.RexsStandardAttributeIds;
import info.rexs.db.constants.standard.RexsStandardComponentTypes;
import info.rexs.db.constants.standard.RexsStandardVersions;
import info.rexs.model.RexsComponent;
import info.rexs.model.RexsModel;
import info.rexs.model.RexsRelation;
import info.rexs.model.RexsRelationRef;
import info.rexs.upgrade.RexsUpgradeException;
import info.rexs.upgrade.upgraders.ModelChangelogUpgrader;
import info.rexs.upgrade.upgraders.ModelUpgraderResult;
import info.rexs.upgrade.upgraders.UpgradeNotifications;
import info.rexs.upgrade.upgraders.changelog.jaxb.RexsChangelogFile;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ModelUpgraderV13toV14 {
    private static final String CHANGELOG_FILENAME = "/info/rexs/upgrade/upgraders/changelog/rexs_changelog_1.3_to_1.4.xml";
    private RexsModel newModel;
    private final RexsModel oldModel;
    private final boolean strictMode;
    private RexsChangelogFile.RexsChangelog changelog;
    private UpgradeNotifications notifications = new UpgradeNotifications();

    public ModelUpgraderV13toV14(RexsModel model, boolean strictMode) {
        this.oldModel = model;
        this.newModel = new RexsModel(model);
        this.strictMode = strictMode;
        try (InputStream stream = this.getClass().getResourceAsStream(CHANGELOG_FILENAME);){
            this.changelog = RexsChangelogFile.load(stream);
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        catch (JAXBException ex) {
            System.err.println((Object)ex);
        }
    }

    public ModelUpgraderResult doupgrade() throws RexsUpgradeException {
        ModelChangelogUpgrader changeLogUpgrader = new ModelChangelogUpgrader(this.newModel, this.changelog, this.strictMode);
        this.newModel = changeLogUpgrader.applyChangelog();
        this.notifications.addAll(changeLogUpgrader.getNotifications().getNotifications());
        this.checkDuplicateReferences(this.newModel);
        this.setCoordinateSystemReference(this.newModel);
        this.newModel.setVersion(RexsStandardVersions.V1_4);
        this.newModel.setApplicationId("REXS API Upgrader");
        return new ModelUpgraderResult(this.newModel, this.notifications);
    }

    private void checkDuplicateReferences(RexsModel model) {
        for (RexsRelation rel : new ArrayList<RexsRelation>(model.getRelations())) {
            this.checkDuplicateReferences(model, rel);
        }
    }

    private void checkDuplicateReferences(RexsModel model, RexsRelation rel) {
        Map<RexsRelationRole, List<RexsRelationRef>> map = rel.getRefs().stream().collect(Collectors.groupingBy(ref -> ref.getRole()));
        boolean hasDuplicate = false;
        for (Map.Entry<RexsRelationRole, List<RexsRelationRef>> entry : map.entrySet()) {
            RexsRelationRole role = entry.getKey();
            if (1 >= entry.getValue().size()) continue;
            this.notifications.add(new UpgradeNotifications.Notification(UpgradeNotifications.NotificationType.FIXME, "relation has more than one reference for role " + role.getKey(), new UpgradeNotifications.RelationSource(rel.getId())));
            hasDuplicate = true;
        }
        if (this.strictMode && hasDuplicate) {
            this.notifications.add(new UpgradeNotifications.Notification(UpgradeNotifications.NotificationType.WARNING, "removed relation that has more than one reference for one role ", new UpgradeNotifications.RelationSource(rel.getId())));
            model.removeRelation(rel);
        }
    }

    private void setCoordinateSystemReference(RexsModel model) {
        for (RexsComponent gearUnitComp : model.getComponentsOfType(RexsStandardComponentTypes.gear_unit)) {
            gearUnitComp.addAttribute(RexsStandardAttributeIds.reference_component_for_position, gearUnitComp.getId());
            this.notifications.add(new UpgradeNotifications.Notification("set coordinate system reference for gear unit", new UpgradeNotifications.ComponentSource(gearUnitComp.getId()), new UpgradeNotifications.AttributeSource(RexsStandardAttributeIds.reference_component_for_position.getId())));
        }
    }
}

