/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.validation;

import info.rexs.model.RexsAttribute;
import info.rexs.model.RexsComponent;
import info.rexs.validation.DefaultRexsAttributeValidator;
import info.rexs.validation.IRexsAttributeValidator;
import info.rexs.validation.IRexsComponentValidator;
import info.rexs.validation.RexsValidationResult;
import info.rexs.validation.RexsValidationResultMessageKey;
import java.util.HashSet;

public class DefaultRexsComponentValidator
implements IRexsComponentValidator {
    @Override
    public RexsValidationResult validate(RexsComponent rexsComponent) {
        RexsValidationResult validationResult = new RexsValidationResult();
        if (rexsComponent.getAttributes() == null || rexsComponent.getAttributes().isEmpty()) {
            validationResult.addWarning(RexsValidationResultMessageKey.COMPONENT_ATTRIBUTES_EMPTY, rexsComponent.toString());
            return validationResult;
        }
        IRexsAttributeValidator attributeValidator = this.createAttributeValidator();
        HashSet<String> existingAttributeIds = new HashSet<String>();
        HashSet<String> existingAttributeIdsReported = new HashSet<String>();
        for (RexsAttribute rexsAttribute : rexsComponent.getAttributes()) {
            validationResult.add(attributeValidator.validate(rexsAttribute, rexsComponent));
            String attributeId = rexsAttribute.getOriginAttributeId();
            if (existingAttributeIds.contains(attributeId) && !existingAttributeIdsReported.contains(attributeId)) {
                validationResult.addWarning(RexsValidationResultMessageKey.COMPONENT_ATTRIBUTE_MULTIPLE, attributeId, rexsComponent.toString());
                existingAttributeIdsReported.add(attributeId);
            }
            existingAttributeIds.add(attributeId);
        }
        return validationResult;
    }

    @Override
    public IRexsAttributeValidator createAttributeValidator() {
        return new DefaultRexsAttributeValidator();
    }
}

