/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.validation;

import info.rexs.io.FileResource;
import info.rexs.io.Resource;
import info.rexs.io.RexsFileReader;
import info.rexs.io.RexsIoFormat;
import info.rexs.io.zip.RexsZipFileReader;
import info.rexs.model.RexsModel;
import info.rexs.schema.RexsSchema;
import info.rexs.validation.DefaultRexsModelValidator;
import info.rexs.validation.IRexsFileValidator;
import info.rexs.validation.IRexsModelValidator;
import info.rexs.validation.RexsValidationResult;
import info.rexs.validation.RexsValidationResultMessageKey;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultRexsFileValidator
implements IRexsFileValidator {
    @Override
    public RexsValidationResult validate(Resource rexsFileResource) {
        RexsValidationResult validationResult = this.validateFilesize(rexsFileResource);
        if (!validationResult.isValid()) {
            return validationResult;
        }
        if (RexsIoFormat.ZIP.hasEnding(rexsFileResource.getFilename())) {
            return this.validateRexszFile(rexsFileResource);
        }
        if (RexsIoFormat.XML.hasEnding(rexsFileResource.getFilename()) && !(validationResult = this.validateSchema(rexsFileResource)).isValid()) {
            return validationResult;
        }
        return this.validateContent(rexsFileResource);
    }

    @Override
    public RexsValidationResult validate(Path pathToRexsFile) {
        return this.validate(new FileResource(pathToRexsFile));
    }

    @Override
    public RexsValidationResult validate(File rexsFile) {
        return this.validate(rexsFile.toPath());
    }

    @Override
    public RexsValidationResult validate(String pathToRexsFile) {
        return this.validate(Paths.get(pathToRexsFile, new String[0]));
    }

    private RexsValidationResult validateFilesize(Resource rexsFileResource) {
        RexsValidationResult validationResult = new RexsValidationResult();
        try {
            if (rexsFileResource.getContentLength() < 1L) {
                validationResult.addError(RexsValidationResultMessageKey.EMPTY_FILE, new String[0]);
            }
        }
        catch (IOException ex) {
            validationResult.addError(RexsValidationResultMessageKey.INTERNAL_ERROR, new String[0]);
        }
        return validationResult;
    }

    private RexsValidationResult validateRexszFile(Resource rexszFileResource) {
        Resource rexsFileInZipResource = null;
        try {
            RexsZipFileReader reader = new RexsZipFileReader(rexszFileResource);
            rexsFileInZipResource = reader.extractRexsFileFromZip();
            return this.validate(rexsFileInZipResource);
        }
        catch (IOException ex) {
            RexsValidationResult validationResult = new RexsValidationResult();
            validationResult.addError(RexsValidationResultMessageKey.INTERNAL_ERROR, new String[0]);
            return validationResult;
        }
    }

    private RexsValidationResult validateSchema(Resource rexsFileResource) {
        RexsValidationResult validationResult = new RexsValidationResult();
        SchemaValidationErrorHandler errorHandler = new SchemaValidationErrorHandler();
        try (InputStream schemaInput = RexsSchema.FILE.openInputStream();
             InputStream rexsFileInput = rexsFileResource.openInputStream();){
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(new StreamSource(schemaInput));
            Validator validator = schema.newValidator();
            validator.setErrorHandler(errorHandler);
            validator.validate(new StreamSource(rexsFileInput));
        }
        catch (IOException | SAXException ex) {
            validationResult.addError(RexsValidationResultMessageKey.INTERNAL_ERROR, new String[0]);
            return validationResult;
        }
        List<String> errorMessages = errorHandler.getErrorMessages();
        for (String error : errorMessages) {
            validationResult.addError(RexsValidationResultMessageKey.XML_SCHEMA, error);
        }
        List<String> warningMessages = errorHandler.getWarningMessages();
        for (String warning : warningMessages) {
            validationResult.addWarning(RexsValidationResultMessageKey.XML_SCHEMA, warning);
        }
        return validationResult;
    }

    private RexsValidationResult validateContent(Resource rexsFileResource) {
        RexsValidationResult validationResult = new RexsValidationResult();
        RexsFileReader reader = new RexsFileReader(rexsFileResource);
        RexsModel rexsModel = null;
        try {
            rexsModel = reader.read();
        }
        catch (Exception ex) {
            validationResult.addError(RexsValidationResultMessageKey.INTERNAL_ERROR, new String[0]);
            return validationResult;
        }
        IRexsModelValidator modelValidator = this.createModelValidator();
        validationResult.add(modelValidator.validate(rexsModel));
        return validationResult;
    }

    @Override
    public IRexsModelValidator createModelValidator() {
        return new DefaultRexsModelValidator();
    }

    private class SchemaValidationErrorHandler
    implements ErrorHandler {
        private List<String> errorMessages = new ArrayList<String>();
        private List<String> warningMessages = new ArrayList<String>();

        private SchemaValidationErrorHandler() {
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            this.errorMessages.add(this.createExceptionMessage(ex));
        }

        public List<String> getWarningMessages() {
            return this.warningMessages;
        }

        public List<String> getErrorMessages() {
            return this.errorMessages;
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            this.errorMessages.add(this.createExceptionMessage(ex));
        }

        @Override
        public void warning(SAXParseException ex) throws SAXException {
            this.warningMessages.add(this.createExceptionMessage(ex));
        }

        private String createExceptionMessage(SAXParseException ex) {
            return String.format("%s (line number: %s, column number: %s)", ex.getMessage(), ex.getLineNumber(), ex.getColumnNumber());
        }
    }
}

