/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.validation;

import info.rexs.db.DbModelRegistry;
import info.rexs.db.IDbModelRegistry;
import info.rexs.db.constants.RexsComponentType;
import info.rexs.db.constants.RexsVersion;
import info.rexs.db.constants.standard.RexsStandardComponentTypes;
import info.rexs.model.RexsComponent;
import info.rexs.validation.DefaultRexsComponentValidator;
import info.rexs.validation.IRexsAttributeValidator;
import info.rexs.validation.RexsStandardAttributeValidator;
import info.rexs.validation.RexsValidationResult;
import info.rexs.validation.RexsValidationResultMessageKey;
import java.util.Objects;

public class RexsStandardComponentValidator
extends DefaultRexsComponentValidator {
    protected final IDbModelRegistry dbModelRegistry;
    protected final RexsVersion rexsVersion;

    public RexsStandardComponentValidator(RexsVersion rexsVersion) {
        this(rexsVersion, DbModelRegistry.getInstance());
    }

    public RexsStandardComponentValidator(RexsVersion rexsVersion, IDbModelRegistry dbModelRegistry) {
        Objects.nonNull(dbModelRegistry);
        this.rexsVersion = rexsVersion;
        this.dbModelRegistry = dbModelRegistry;
    }

    @Override
    public RexsValidationResult validate(RexsComponent rexsComponent) {
        RexsValidationResult validationResult = super.validate(rexsComponent);
        if (this.rexsVersion == null) {
            return validationResult;
        }
        String componentType = rexsComponent.getOriginType();
        RexsComponentType rexsComponentType = this.dbModelRegistry.getComponentType(this.rexsVersion, componentType);
        if (rexsComponentType.isOneOf(RexsStandardComponentTypes.UNKNOWN)) {
            validationResult.addError(RexsValidationResultMessageKey.COMPONENT_TYPE_UNKNOWN, componentType);
        }
        return validationResult;
    }

    @Override
    public IRexsAttributeValidator createAttributeValidator() {
        if (this.rexsVersion == null) {
            return super.createAttributeValidator();
        }
        return new RexsStandardAttributeValidator(this.rexsVersion, this.dbModelRegistry);
    }
}

