/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.db;

import info.rexs.db.DbModelFileResolver;
import info.rexs.db.constants.RexsVersion;
import info.rexs.db.constants.standard.RexsStandardVersions;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

public class DbModelFile {
    private static final DbModelFileResolver DEFAULT_FILE_RESOLVER = new DbModelFileResolver();
    private static Set<DbModelFile> allDbModelFiles = new HashSet<DbModelFile>();
    public static final DbModelFile V1_0 = DbModelFile.create(RexsStandardVersions.V1_0);
    public static final DbModelFile V1_1 = DbModelFile.create(RexsStandardVersions.V1_1);
    public static final DbModelFile V1_2 = DbModelFile.create(RexsStandardVersions.V1_2);
    public static final DbModelFile V1_3 = DbModelFile.create(RexsStandardVersions.V1_3);
    public static final DbModelFile V1_4 = DbModelFile.create(RexsStandardVersions.V1_4);
    public static final DbModelFile V1_5 = DbModelFile.create(RexsStandardVersions.V1_5);
    public static final DbModelFile V1_6 = DbModelFile.create(RexsStandardVersions.V1_6);
    private final RexsVersion version;
    private final DbModelFileResolver fileResolver;

    private DbModelFile(RexsVersion version, DbModelFileResolver fileResolver) {
        if (version == null) {
            throw new IllegalArgumentException("version cannot be empty");
        }
        this.version = version;
        this.fileResolver = fileResolver;
    }

    public RexsVersion getVersion() {
        return this.version;
    }

    public InputStream openInputStream() {
        return this.fileResolver.openInputStream(this);
    }

    public static DbModelFile create(RexsVersion version, DbModelFileResolver fileResolver) {
        if (fileResolver == null) {
            fileResolver = DEFAULT_FILE_RESOLVER;
        }
        DbModelFile dbModelFile = new DbModelFile(version, fileResolver);
        allDbModelFiles.add(dbModelFile);
        return dbModelFile;
    }

    public static DbModelFile create(RexsVersion version) {
        return DbModelFile.create(version, null);
    }

    public static DbModelFile findByVersion(RexsVersion version) {
        if (version == null) {
            return null;
        }
        for (DbModelFile dbModelFile : allDbModelFiles) {
            if (!version.equals(dbModelFile.version)) continue;
            return dbModelFile;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbModelFile)) {
            return false;
        }
        DbModelFile other = (DbModelFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RexsVersion this_version = this.getVersion();
        RexsVersion other_version = other.getVersion();
        return this_version == null ? other_version == null : ((Object)this_version).equals(other_version);
    }

    protected boolean canEqual(Object other) {
        return other instanceof DbModelFile;
    }

    public int hashCode() {
        int result = 1;
        RexsVersion _version = this.getVersion();
        result = result * 59 + (_version == null ? 43 : ((Object)_version).hashCode());
        return result;
    }
}

