/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.db.constants;

import info.rexs.db.constants.RexsUnitId;
import info.rexs.db.constants.standard.RexsStandardAttributeIds;
import java.util.HashMap;
import java.util.Map;

public class RexsAttributeId
implements RexsStandardAttributeIds {
    private static Map<String, RexsAttributeId> allAttributeIds = new HashMap<String, RexsAttributeId>();
    private final String id;
    private final RexsUnitId unit;

    private RexsAttributeId(String id, RexsUnitId unit) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("id cannot be empty");
        }
        if (unit == null) {
            throw new IllegalArgumentException("unit cannot be empty");
        }
        this.id = id;
        this.unit = unit;
    }

    public String getId() {
        return this.id;
    }

    public RexsUnitId getUnit() {
        return this.unit;
    }

    public boolean isOneOf(RexsAttributeId ... checkAttributeIds) {
        if (checkAttributeIds == null) {
            return false;
        }
        for (RexsAttributeId checkAttributeId : checkAttributeIds) {
            if (!this.equals(checkAttributeId)) continue;
            return true;
        }
        return false;
    }

    public static RexsAttributeId create(String id, RexsUnitId unit) {
        RexsAttributeId attributeId = new RexsAttributeId(id, unit);
        allAttributeIds.put(id, attributeId);
        return attributeId;
    }

    public static RexsAttributeId findById(String id) {
        if (id == null) {
            return null;
        }
        RexsStandardAttributeIds.init();
        return allAttributeIds.getOrDefault(id, RexsStandardAttributeIds.UNKNOWN);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RexsAttributeId)) {
            return false;
        }
        RexsAttributeId other = (RexsAttributeId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this_id = this.getId();
        String other_id = other.getId();
        if (this_id == null ? other_id != null : !this_id.equals(other_id)) {
            return false;
        }
        RexsUnitId this_unit = this.getUnit();
        RexsUnitId other_unit = other.getUnit();
        return this_unit == null ? other_unit == null : this_unit.equals(other_unit);
    }

    protected boolean canEqual(Object other) {
        return other instanceof RexsAttributeId;
    }

    public int hashCode() {
        int result = 1;
        String _id = this.getId();
        result = result * 59 + (_id == null ? 43 : _id.hashCode());
        RexsUnitId _unit = this.getUnit();
        result = result * 59 + (_unit == null ? 43 : _unit.hashCode());
        return result;
    }
}

