/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.db.constants;

public enum RexsValueType {
    BOOLEAN(2, "boolean"),
    BOOLEAN_ARRAY(7, "boolean_array", BOOLEAN),
    BOOLEAN_MATRIX(16, "boolean_matrix", BOOLEAN),
    STRING(5, "string"),
    STRING_ARRAY(14, "string_array", STRING),
    STRING_MATRIX(17, "string_matrix", STRING),
    INTEGER(3, "integer"),
    INTEGER_ARRAY(11, "integer_array", INTEGER),
    INTEGER_MATRIX(15, "integer_matrix", INTEGER),
    FLOATING_POINT(1, "floating_point"),
    FLOATING_POINT_ARRAY(8, "floating_point_array", FLOATING_POINT),
    FLOATING_POINT_MATRIX(10, "floating_point_matrix", FLOATING_POINT),
    ENUM(4, "enum"),
    ENUM_ARRAY(12, "enum_array", ENUM),
    ARRAY_OF_INTEGER_ARRAYS(13, "array_of_integer_arrays", INTEGER),
    REFERENCE_COMPONENT(9, "reference_component"),
    FILE_REFERENCE(6, "file_reference"),
    DATE_TIME(19, "date_time");

    private final int numericId;
    private final String key;
    private final RexsValueType basicType;

    private RexsValueType(int id, String key) {
        this(id, key, null);
    }

    private RexsValueType(int id, String key, RexsValueType basicType) {
        this.numericId = id;
        this.key = key;
        this.basicType = basicType;
    }

    public int getNumericId() {
        return this.numericId;
    }

    public String getKey() {
        return this.key;
    }

    public RexsValueType getBasicType() {
        if (this.basicType == null) {
            return this;
        }
        return this.basicType;
    }

    public boolean isOneOf(RexsValueType ... checkValueTypes) {
        if (checkValueTypes == null) {
            return false;
        }
        for (RexsValueType checkValueType : checkValueTypes) {
            if (this != checkValueType) continue;
            return true;
        }
        return false;
    }

    public static RexsValueType findByKey(String key) {
        if (key == null) {
            return null;
        }
        for (RexsValueType valueType : RexsValueType.values()) {
            if (!key.equals(valueType.getKey())) continue;
            return valueType;
        }
        return null;
    }

    public static RexsValueType findByNumericId(int numericId) {
        for (RexsValueType valueType : RexsValueType.values()) {
            if (valueType.getNumericId() != numericId) continue;
            return valueType;
        }
        return null;
    }
}

