/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.io;

import info.rexs.io.Resource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class FileResource
implements Resource {
    private final Path filePath;

    public FileResource(Path filePath) {
        this.filePath = filePath;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        try {
            return Files.newInputStream(this.filePath, new OpenOption[0]);
        }
        catch (NoSuchFileException ex) {
            throw new FileNotFoundException(ex.getMessage());
        }
    }

    @Override
    public boolean exists() {
        return Files.exists(this.filePath, new LinkOption[0]);
    }

    @Override
    public long getContentLength() throws IOException {
        try {
            return Files.size(this.filePath);
        }
        catch (NoSuchFileException ex) {
            throw new FileNotFoundException(ex.getMessage());
        }
    }

    @Override
    public String getFilename() {
        return this.filePath.getFileName().toString();
    }
}

