/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.io;

import info.rexs.io.AbstractRexsFileReader;
import info.rexs.io.Resource;
import info.rexs.io.RexsIoException;
import info.rexs.io.RexsIoFormat;
import info.rexs.model.RexsModel;
import java.io.File;
import java.nio.file.Path;

public class RexsFileReader
extends AbstractRexsFileReader {
    public RexsFileReader(Resource rexsInputFileResource) {
        super(rexsInputFileResource);
    }

    public RexsFileReader(Path pathToRexsInputFile) {
        super(pathToRexsInputFile);
    }

    public RexsFileReader(File rexsInputFile) {
        super(rexsInputFile);
    }

    public RexsFileReader(String rexsInputFilePath) {
        super(rexsInputFilePath);
    }

    @Override
    public RexsModel read() throws RexsIoException {
        this.validateInputFile();
        RexsIoFormat format = RexsIoFormat.findFormatByFilename(this.rexsInputFileResource.getFilename());
        if (format == null) {
            throw new RexsIoException("rexs file " + this.rexsInputFileResource.getFilename() + " has unknown filename ending");
        }
        AbstractRexsFileReader reader = format.createNewFileReader(this.rexsInputFileResource);
        return reader.read();
    }
}

