/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.io.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import info.rexs.db.constants.RexsUnitId;
import info.rexs.db.constants.RexsVersion;
import info.rexs.db.constants.standard.RexsStandardUnitIds;
import info.rexs.db.constants.standard.RexsStandardVersions;
import info.rexs.io.AbstractRexsFileWriter;
import info.rexs.io.RexsIoException;
import info.rexs.io.json.model.Accumulation;
import info.rexs.io.json.model.Component;
import info.rexs.io.json.model.JSONModel;
import info.rexs.io.json.model.LoadCase;
import info.rexs.io.json.model.LoadSpectrum;
import info.rexs.io.json.model.Model;
import info.rexs.io.json.model.attributes.ArrayOfIntegerArraysAttribute;
import info.rexs.io.json.model.attributes.Attribute;
import info.rexs.io.json.model.attributes.BooleanArrayAttribute;
import info.rexs.io.json.model.attributes.BooleanAttribute;
import info.rexs.io.json.model.attributes.BooleanMatrixAttribute;
import info.rexs.io.json.model.attributes.DateTimeAttribute;
import info.rexs.io.json.model.attributes.EnumArrayAttribute;
import info.rexs.io.json.model.attributes.EnumAttribute;
import info.rexs.io.json.model.attributes.FileReferenceAttribute;
import info.rexs.io.json.model.attributes.FloatingPointArrayAttribute;
import info.rexs.io.json.model.attributes.FloatingPointAttribute;
import info.rexs.io.json.model.attributes.FloatingPointMatrixAttribute;
import info.rexs.io.json.model.attributes.IntegerArrayAttribute;
import info.rexs.io.json.model.attributes.IntegerAttribute;
import info.rexs.io.json.model.attributes.IntegerMatrixAttribute;
import info.rexs.io.json.model.attributes.ReferenceComponentAttribute;
import info.rexs.io.json.model.attributes.StringArrayAttribute;
import info.rexs.io.json.model.attributes.StringAttribute;
import info.rexs.io.json.model.attributes.StringMatrixAttribute;
import info.rexs.model.RexsModel;
import info.rexs.model.transformer.RexsModelJsonTransformer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;

public class RexsJsonFileWriter
extends AbstractRexsFileWriter {
    public RexsJsonFileWriter(Path pathToRexsOutputFile) {
        super(pathToRexsOutputFile);
    }

    public RexsJsonFileWriter(File rexsOutputFile) {
        super(rexsOutputFile);
    }

    public RexsJsonFileWriter(String rexsOutputFilePath) {
        super(rexsOutputFilePath);
    }

    @Override
    public void write(RexsModel model) throws RexsIoException {
        this.validateOutputFile();
        String jsonString = "";
        try {
            RexsModelJsonTransformer transformer = new RexsModelJsonTransformer();
            JSONModel rawModel = transformer.transform(model);
            this.convertDegreeUnits(rawModel.getModel());
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerSubtypes(new Class[]{DateTimeAttribute.class, BooleanAttribute.class, EnumAttribute.class, FloatingPointAttribute.class, IntegerAttribute.class, StringAttribute.class, BooleanArrayAttribute.class, EnumArrayAttribute.class, FloatingPointArrayAttribute.class, IntegerArrayAttribute.class, StringArrayAttribute.class, BooleanMatrixAttribute.class, FloatingPointMatrixAttribute.class, IntegerMatrixAttribute.class, StringMatrixAttribute.class, ArrayOfIntegerArraysAttribute.class, FileReferenceAttribute.class, ReferenceComponentAttribute.class});
            jsonString = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rawModel);
        }
        catch (Exception ex) {
            throw new RexsIoException("error on writing rexs model to json file", ex);
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.pathToRexsOutputFile.toString(), StandardCharsets.UTF_8));){
            writer.write("\ufeff");
            writer.write(jsonString);
            writer.flush();
        }
        catch (IOException ex) {
            throw new RexsIoException("error on writing rexs model to json file", ex);
        }
    }

    private void convertDegreeUnits(Model model) {
        if (model.getComponents() == null || model.getComponents().isEmpty()) {
            return;
        }
        String versionName = model.getVersion();
        RexsVersion version = RexsVersion.findByName(versionName);
        if (version == null) {
            return;
        }
        RexsUnitId searchUnit = version.isLess(RexsStandardVersions.V1_4) ? RexsStandardUnitIds.deg : RexsStandardUnitIds.degree;
        RexsUnitId replaceUnit = version.isLess(RexsStandardVersions.V1_4) ? RexsStandardUnitIds.degree : RexsStandardUnitIds.deg;
        ArrayList<Component> allComponents = new ArrayList<Component>();
        allComponents.addAll(model.getComponents());
        LoadSpectrum spectrum = model.getLoadSpectrum();
        if (spectrum != null) {
            for (LoadCase loadCase : spectrum.getLoadCases()) {
                allComponents.addAll(loadCase.getComponents());
            }
            Accumulation accumulation = spectrum.getAccumulation();
            if (accumulation != null) {
                allComponents.addAll(accumulation.getComponents());
            }
        }
        for (Component component : allComponents) {
            for (Attribute attribute : component.getAttributes()) {
                if (attribute == null || attribute.getUnit() == null || !attribute.getUnit().equals(searchUnit.getId())) continue;
                attribute.setUnit(replaceUnit.getId());
            }
        }
    }
}

