/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.io.zip;

import info.rexs.io.AbstractRexsFileReader;
import info.rexs.io.ByteArrayResource;
import info.rexs.io.Resource;
import info.rexs.io.RexsFileReader;
import info.rexs.io.RexsIoException;
import info.rexs.io.RexsIoFormat;
import info.rexs.model.RexsModel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class RexsZipFileReader
extends AbstractRexsFileReader {
    public RexsZipFileReader(Resource rexsInputFileResource) {
        super(rexsInputFileResource);
    }

    public RexsZipFileReader(Path pathToRexsInputFile) {
        super(pathToRexsInputFile);
    }

    public RexsZipFileReader(File rexsInputFile) {
        super(rexsInputFile);
    }

    public RexsZipFileReader(String rexsInputFilePath) {
        super(rexsInputFilePath);
    }

    @Override
    public RexsModel read() throws RexsIoException {
        this.validateInputFile();
        Resource rexsFileInZipResource = null;
        try {
            rexsFileInZipResource = this.extractRexsFileFromZip();
            if (rexsFileInZipResource == null) {
                throw new RexsIoException("unable to locate rexs file in rexs zip archive " + this.rexsInputFileResource.getFilename());
            }
            RexsFileReader reader = new RexsFileReader(rexsFileInZipResource);
            return reader.read();
        }
        catch (IOException ex) {
            throw new RexsIoException("error on reading rexs model from zip file", ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Resource extractRexsFileFromZip() throws IOException {
        try (ZipInputStream input = new ZipInputStream(this.rexsInputFileResource.openInputStream());){
            ZipEntry entry;
            while ((entry = input.getNextEntry()) != null) {
                ByteArrayResource byteArrayResource;
                RexsIoFormat format = RexsIoFormat.findFormatByFilename(entry.getName());
                if (format == null) continue;
                byte[] buffer = new byte[2048];
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                try {
                    int len;
                    while ((len = input.read(buffer)) > 0) {
                        output.write(buffer, 0, len);
                    }
                    byteArrayResource = new ByteArrayResource(output.toByteArray(), entry.getName());
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            output.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                        return null;
                    }
                }
                output.close();
                return byteArrayResource;
            }
        }
    }
}

