/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.model.util;

import info.rexs.model.RexsModelAccessException;
import info.rexs.model.util.JavaDatatypeUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Base64;

public class Base64Utils {
    private Base64Utils() {
    }

    public static String encodeInt32Array(int[] array) {
        return Base64.getEncoder().encodeToString(Base64Utils.intToByteArray(array));
    }

    public static int[] decodeInt32Array(String base64Encoded) {
        if (Base64Utils.isEmpty(base64Encoded)) {
            return null;
        }
        byte[] byteArray = Base64.getDecoder().decode(base64Encoded);
        return Base64Utils.byteToIntArray(byteArray);
    }

    public static Integer[] decodeInt32ArrayBoxed(String base64Encoded) {
        if (Base64Utils.isEmpty(base64Encoded)) {
            return null;
        }
        int[] intArray = Base64Utils.decodeInt32Array(base64Encoded);
        return JavaDatatypeUtils.boxIntArray(intArray);
    }

    public static String encodeFloat32Array(float[] array) {
        return Base64.getEncoder().encodeToString(Base64Utils.floatToByteArray(array));
    }

    public static float[] decodeFloat32Array(String base64Encoded) {
        if (Base64Utils.isEmpty(base64Encoded)) {
            return null;
        }
        byte[] byteArray = Base64.getDecoder().decode(base64Encoded);
        return Base64Utils.byteToFloatArray(byteArray);
    }

    public static Double[] decodeFloat32ArrayBoxed(String base64Encoded) {
        if (Base64Utils.isEmpty(base64Encoded)) {
            return null;
        }
        float[] floatArray = Base64Utils.decodeFloat32Array(base64Encoded);
        return JavaDatatypeUtils.boxFloatArray(floatArray);
    }

    public static String encodeFloat64Array(double[] array) {
        return Base64.getEncoder().encodeToString(Base64Utils.doubleToByteArray(array));
    }

    public static double[] decodeFloat64Array(String base64Encoded) {
        if (Base64Utils.isEmpty(base64Encoded)) {
            return null;
        }
        byte[] byteArray = Base64.getDecoder().decode(base64Encoded);
        return Base64Utils.byteToDoubleArray(byteArray);
    }

    public static Double[] decodeFloat64ArrayBoxed(String base64Encoded) {
        if (Base64Utils.isEmpty(base64Encoded)) {
            return null;
        }
        double[] doubleArray = Base64Utils.decodeFloat64Array(base64Encoded);
        return JavaDatatypeUtils.boxDoubleArray(doubleArray);
    }

    private static byte[] intToByteArray(int[] array) {
        ByteBuffer buf = ByteBuffer.allocate(4 * array.length);
        buf.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer().put(array);
        return buf.array();
    }

    private static byte[] floatToByteArray(float[] array) {
        ByteBuffer buf = ByteBuffer.allocate(4 * array.length);
        buf.order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer().put(array);
        return buf.array();
    }

    private static byte[] doubleToByteArray(double[] array) {
        ByteBuffer buf = ByteBuffer.allocate(8 * array.length);
        buf.order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer().put(array);
        return buf.array();
    }

    private static int[] byteToIntArray(byte[] bytes) {
        IntBuffer buf = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        int[] array = new int[buf.limit()];
        buf.get(array);
        return array;
    }

    private static float[] byteToFloatArray(byte[] bytes) {
        FloatBuffer buf = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer();
        float[] array = new float[buf.limit()];
        buf.get(array);
        return array;
    }

    private static double[] byteToDoubleArray(byte[] bytes) {
        DoubleBuffer buf = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer();
        double[] array = new double[buf.limit()];
        buf.get(array);
        return array;
    }

    public static String encodeInt32Matrix(int[][] matrix) {
        int[] array = Base64Utils.flatIntMatrix(matrix);
        return Base64Utils.encodeInt32Array(array);
    }

    public static int[][] decodeInt32Matrix(String base64Encoded, int rows, int cols) {
        if (Base64Utils.isEmpty(base64Encoded)) {
            return null;
        }
        int[] intArray = Base64Utils.decodeInt32Array(base64Encoded);
        return Base64Utils.unflatIntMatrix(intArray, rows, cols);
    }

    public static Integer[][] decodeInt32MatrixBoxed(String base64Encoded, int rows, int cols) {
        if (Base64Utils.isEmpty(base64Encoded)) {
            return null;
        }
        int[][] intMatrix = Base64Utils.decodeInt32Matrix(base64Encoded, rows, cols);
        return JavaDatatypeUtils.boxIntMatrix(intMatrix);
    }

    public static String encodeFloat32Matrix(float[][] matrix) {
        float[] array = Base64Utils.flatFloatMatrix(matrix);
        return Base64Utils.encodeFloat32Array(array);
    }

    public static float[][] decodeFloat32Matrix(String base64Encoded, int rows, int cols) {
        if (Base64Utils.isEmpty(base64Encoded)) {
            return null;
        }
        float[] floatArray = Base64Utils.decodeFloat32Array(base64Encoded);
        return Base64Utils.unflatFloatMatrix(floatArray, rows, cols);
    }

    public static Double[][] decodeFloat32MatrixBoxed(String base64Encoded, int rows, int cols) {
        if (Base64Utils.isEmpty(base64Encoded)) {
            return null;
        }
        float[][] floatMatrix = Base64Utils.decodeFloat32Matrix(base64Encoded, rows, cols);
        return JavaDatatypeUtils.boxFloatMatrix(floatMatrix);
    }

    public static String encodeFloat64Matrix(double[][] matrix) {
        double[] array = Base64Utils.flatDoubleMatrix(matrix);
        return Base64Utils.encodeFloat64Array(array);
    }

    public static double[][] decodeFloat64Matrix(String base64Encoded, int rows, int cols) {
        if (Base64Utils.isEmpty(base64Encoded)) {
            return null;
        }
        double[] doubleArray = Base64Utils.decodeFloat64Array(base64Encoded);
        return Base64Utils.unflatDoubleMatrix(doubleArray, rows, cols);
    }

    public static Double[][] decodeFloat64MatrixBoxed(String base64Encoded, int rows, int cols) {
        if (Base64Utils.isEmpty(base64Encoded)) {
            return null;
        }
        double[][] doubleMatrix = Base64Utils.decodeFloat64Matrix(base64Encoded, rows, cols);
        return JavaDatatypeUtils.boxDoubleMatrix(doubleMatrix);
    }

    private static int[] flatIntMatrix(int[][] matrix) {
        if (matrix.length == 0) {
            return new int[0];
        }
        int arrayLength = 0;
        int numRows = matrix.length;
        int numColumns = matrix[0].length;
        for (int i = 0; i < numRows; ++i) {
            if (matrix[i].length != numColumns) {
                throw new RexsModelAccessException("tried to encode non-rectangular matrix in base64");
            }
            arrayLength += numColumns;
        }
        int[] array = new int[arrayLength];
        int arrayIndex = 0;
        for (int col = 0; col < numColumns; ++col) {
            for (int row = 0; row < numRows; ++row) {
                array[arrayIndex++] = matrix[row][col];
            }
        }
        return array;
    }

    private static float[] flatFloatMatrix(float[][] matrix) {
        if (matrix.length == 0) {
            return new float[0];
        }
        int arrayLength = 0;
        int numRows = matrix.length;
        int numColumns = matrix[0].length;
        for (int i = 0; i < numRows; ++i) {
            if (matrix[i].length != numColumns) {
                throw new RexsModelAccessException("tried to encode non-rectangular matrix in base64");
            }
            arrayLength += numColumns;
        }
        float[] array = new float[arrayLength];
        int arrayIndex = 0;
        for (int col = 0; col < numColumns; ++col) {
            for (int row = 0; row < numRows; ++row) {
                array[arrayIndex++] = matrix[row][col];
            }
        }
        return array;
    }

    private static double[] flatDoubleMatrix(double[][] matrix) {
        if (matrix.length == 0) {
            return new double[0];
        }
        int arrayLength = 0;
        int numRows = matrix.length;
        int numColumns = matrix[0].length;
        for (int i = 0; i < numRows; ++i) {
            if (matrix[i].length != numColumns) {
                throw new RexsModelAccessException("tried to encode non-rectangular matrix in base64");
            }
            arrayLength += numColumns;
        }
        double[] array = new double[arrayLength];
        int arrayIndex = 0;
        for (int col = 0; col < numColumns; ++col) {
            for (int row = 0; row < numRows; ++row) {
                array[arrayIndex++] = matrix[row][col];
            }
        }
        return array;
    }

    private static int[][] unflatIntMatrix(int[] array, int rows, int cols) {
        int[][] matrix = new int[rows][cols];
        for (int i = 0; i < array.length; ++i) {
            int rowIndex = i % rows;
            int colIndex = i / rows;
            matrix[rowIndex][colIndex] = array[i];
        }
        return matrix;
    }

    private static float[][] unflatFloatMatrix(float[] array, int rows, int cols) {
        float[][] matrix = new float[rows][cols];
        for (int i = 0; i < array.length; ++i) {
            int rowIndex = i % rows;
            int colIndex = i / rows;
            matrix[rowIndex][colIndex] = array[i];
        }
        return matrix;
    }

    private static double[][] unflatDoubleMatrix(double[] array, int rows, int cols) {
        double[][] matrix = new double[rows][cols];
        for (int i = 0; i < array.length; ++i) {
            int rowIndex = i % rows;
            int colIndex = i / rows;
            matrix[rowIndex][colIndex] = array[i];
        }
        return matrix;
    }

    private static boolean isEmpty(String value) {
        return value == null || value.length() < 1;
    }
}

