/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.model.value;

import info.rexs.model.RexsModelAccessException;
import info.rexs.model.value.AbstractRexsAttributeValue;
import java.util.List;

public abstract class AbstractRexsAttributeValueArray
extends AbstractRexsAttributeValue {
    protected String[] convertStringListToStringArray(List<String> stringList) {
        String[] stringArray = new String[stringList.size()];
        for (int i = 0; i < stringList.size(); ++i) {
            stringArray[i] = stringList.get(i);
        }
        return stringArray;
    }

    protected Boolean[] convertStringListToBooleanArray(List<String> stringList) {
        Boolean[] booleanArray = new Boolean[stringList.size()];
        for (int i = 0; i < stringList.size(); ++i) {
            String stringValue = stringList.get(i);
            if (stringValue.isEmpty()) continue;
            if (!stringValue.equals("false") && !stringValue.equals("true")) {
                throw new RexsModelAccessException("cannot read boolean value " + stringValue);
            }
            booleanArray[i] = Boolean.valueOf(stringValue);
        }
        return booleanArray;
    }

    protected Integer[] convertStringListToIntegerArrayBoxed(List<String> stringList) {
        Integer[] integerArray = new Integer[stringList.size()];
        for (int i = 0; i < stringList.size(); ++i) {
            String stringValue = stringList.get(i);
            if (stringValue.isEmpty()) continue;
            try {
                integerArray[i] = Integer.parseInt(stringValue);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new RexsModelAccessException("cannot read integer value " + stringValue, ex);
            }
        }
        return integerArray;
    }

    protected int[] convertStringListToIntegerArrayUnboxed(List<String> stringList) {
        int[] integerArray = new int[stringList.size()];
        for (int i = 0; i < stringList.size(); ++i) {
            String stringValue = stringList.get(i);
            if (stringValue.isEmpty()) continue;
            try {
                integerArray[i] = Integer.parseInt(stringValue);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new RexsModelAccessException("cannot read integer value " + stringValue, ex);
            }
        }
        return integerArray;
    }

    protected Double[] convertStringListToDoubleArrayBoxed(List<String> stringList) {
        Double[] doubleArray = new Double[stringList.size()];
        for (int i = 0; i < stringList.size(); ++i) {
            String stringValue = stringList.get(i);
            if (stringValue.isEmpty()) continue;
            try {
                doubleArray[i] = Double.parseDouble(stringValue);
                if (!Double.isNaN(doubleArray[i])) continue;
                doubleArray[i] = null;
                continue;
            }
            catch (NumberFormatException ex) {
                throw new RexsModelAccessException("cannot read double value " + stringValue, ex);
            }
        }
        return doubleArray;
    }

    protected double[] convertStringListToDoubleArrayUnboxed(List<String> stringList) {
        double[] doubleArray = new double[stringList.size()];
        for (int i = 0; i < stringList.size(); ++i) {
            String stringValue = stringList.get(i);
            if (stringValue.isEmpty()) continue;
            try {
                double parsedDouble = Double.parseDouble(stringValue);
                if (Double.isNaN(parsedDouble)) continue;
                doubleArray[i] = parsedDouble;
                continue;
            }
            catch (NumberFormatException ex) {
                throw new RexsModelAccessException("cannot read double value " + stringValue, ex);
            }
        }
        return doubleArray;
    }

    protected double[] convertFloatArrayToDoubleArray(float[] input) {
        if (input == null) {
            return null;
        }
        double[] output = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            output[i] = input[i];
        }
        return output;
    }
}

