/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.model.value;

import info.rexs.model.RexsModelAccessException;
import info.rexs.model.value.AbstractRexsAttributeValue;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractRexsAttributeValueMatrix
extends AbstractRexsAttributeValue {
    protected String[][] convertStringMatrixToStringMatrix(List<List<String>> stringMatrix) {
        String[][] newStringMatrix = new String[stringMatrix.size()][stringMatrix.get(0).size()];
        for (int i = 0; i < stringMatrix.size(); ++i) {
            List<String> stringArray = stringMatrix.get(i);
            for (int j = 0; j < stringArray.size(); ++j) {
                newStringMatrix[i][j] = stringArray.get(j);
            }
        }
        return newStringMatrix;
    }

    protected Boolean[][] convertStringMatrixToBooleanMatrix(List<List<String>> stringMatrix) {
        Boolean[][] booleanMatrix = new Boolean[stringMatrix.size()][stringMatrix.get(0).size()];
        for (int i = 0; i < stringMatrix.size(); ++i) {
            List<String> stringArray = stringMatrix.get(i);
            for (int j = 0; j < stringArray.size(); ++j) {
                String stringValue = stringArray.get(j);
                if (stringValue.isEmpty()) continue;
                booleanMatrix[i][j] = Boolean.valueOf(stringValue);
            }
        }
        return booleanMatrix;
    }

    protected Integer[][] convertStringMatrixToIntegerMatrixBoxed(List<List<String>> stringMatrix) {
        Integer[][] integerMatrix = new Integer[stringMatrix.size()][stringMatrix.get(0).size()];
        for (int i = 0; i < stringMatrix.size(); ++i) {
            List<String> stringArray = stringMatrix.get(i);
            for (int j = 0; j < stringArray.size(); ++j) {
                String stringValue = stringArray.get(j);
                if (stringValue.isEmpty()) continue;
                try {
                    integerMatrix[i][j] = Integer.parseInt(stringValue);
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new RexsModelAccessException("cannot read integer value " + stringValue, ex);
                }
            }
        }
        return integerMatrix;
    }

    protected int[][] convertStringMatrixToIntegerMatrixUnboxed(List<List<String>> stringMatrix) {
        int[][] integerMatrix = new int[stringMatrix.size()][stringMatrix.get(0).size()];
        for (int i = 0; i < stringMatrix.size(); ++i) {
            List<String> stringArray = stringMatrix.get(i);
            for (int j = 0; j < stringArray.size(); ++j) {
                String stringValue = stringArray.get(j);
                if (stringValue.isEmpty()) continue;
                try {
                    integerMatrix[i][j] = Integer.parseInt(stringValue);
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new RexsModelAccessException("cannot read integer value " + stringValue, ex);
                }
            }
        }
        return integerMatrix;
    }

    protected Double[][] convertStringMatrixToDoubleMatrixBoxed(List<List<String>> stringMatrix) {
        Double[][] doubleMatrix = new Double[stringMatrix.size()][stringMatrix.get(0).size()];
        for (int i = 0; i < stringMatrix.size(); ++i) {
            List<String> stringArray = stringMatrix.get(i);
            for (int j = 0; j < stringArray.size(); ++j) {
                String stringValue = stringArray.get(j);
                if (stringValue.isEmpty()) continue;
                try {
                    doubleMatrix[i][j] = Double.parseDouble(stringValue);
                    if (!Double.isNaN(doubleMatrix[i][j])) continue;
                    doubleMatrix[i][j] = null;
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new RexsModelAccessException("cannot read double value " + stringValue, ex);
                }
            }
        }
        return doubleMatrix;
    }

    protected double[][] convertStringMatrixToDoubleMatrixUnboxed(List<List<String>> stringMatrix) {
        double[][] doubleMatrix = new double[stringMatrix.size()][stringMatrix.get(0).size()];
        for (int i = 0; i < stringMatrix.size(); ++i) {
            List<String> stringArray = stringMatrix.get(i);
            for (int j = 0; j < stringArray.size(); ++j) {
                String stringValue = stringArray.get(j);
                if (stringValue.isEmpty()) continue;
                try {
                    double parsedDouble = Double.parseDouble(stringValue);
                    if (Double.isNaN(parsedDouble)) continue;
                    doubleMatrix[i][j] = parsedDouble;
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new RexsModelAccessException("cannot read double value " + stringValue, ex);
                }
            }
        }
        return doubleMatrix;
    }

    protected double[][] convertFloatMatrixToDoubleMatrix(float[][] input) {
        if (input == null) {
            return null;
        }
        int colLength = Arrays.stream(input).mapToInt(col -> ((float[])col).length).max().orElse(0);
        double[][] output = new double[input.length][colLength];
        for (int i = 0; i < input.length; ++i) {
            for (int j = 0; j < input[i].length; ++j) {
                output[i][j] = input[i][j];
            }
        }
        return output;
    }
}

