/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.model.value;

import info.rexs.model.util.JavaDatatypeUtils;
import info.rexs.model.value.AbstractRexsAttributeValue;
import info.rexs.model.value.AbstractRexsAttributeValueArray;
import java.util.ArrayList;
import java.util.List;

public class RexsAttributeValueArray
extends AbstractRexsAttributeValueArray {
    private List<String> value = null;

    public RexsAttributeValueArray() {
    }

    public RexsAttributeValueArray(List<String> value) {
        this.value = value;
    }

    @Override
    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    @Override
    public AbstractRexsAttributeValue copy() {
        return new RexsAttributeValueArray(new ArrayList<String>(this.value));
    }

    @Override
    public Boolean[] getValueBooleanArray() {
        Boolean[] val = null;
        if (this.value != null && !this.value.isEmpty()) {
            val = this.convertStringListToBooleanArray(this.value);
        }
        return val;
    }

    @Override
    public String[] getValueStringArray() {
        String[] val = null;
        if (this.value != null && !this.value.isEmpty()) {
            val = this.convertStringListToStringArray(this.value);
        }
        return val;
    }

    @Override
    public Integer[] getValueIntegerArray() {
        Integer[] val = null;
        if (this.value != null && !this.value.isEmpty()) {
            val = this.convertStringListToIntegerArrayBoxed(this.value);
        }
        return val;
    }

    @Override
    public int[] getValueIntegerArrayUnboxed() {
        int[] val = null;
        if (this.value != null && !this.value.isEmpty()) {
            val = this.convertStringListToIntegerArrayUnboxed(this.value);
        }
        return val;
    }

    @Override
    public Double[] getValueDoubleArray() {
        Double[] val = null;
        if (this.value != null && !this.value.isEmpty()) {
            val = this.convertStringListToDoubleArrayBoxed(this.value);
        }
        return val;
    }

    @Override
    public double[] getValueDoubleArrayUnboxed() {
        double[] val = null;
        if (this.value != null && !this.value.isEmpty()) {
            val = this.convertStringListToDoubleArrayUnboxed(this.value);
        }
        return val;
    }

    public void setValueBooleanArray(Boolean[] value) {
        this.setValue(value);
    }

    public void setValueStringArray(String[] value) {
        this.setValue(value);
    }

    public void setValueIntegerArray(Integer[] value) {
        this.setValue(value);
    }

    public void setValueIntegerArray(int[] value) {
        this.setValue(JavaDatatypeUtils.boxIntArray(value));
    }

    public void setValueDoubleArray(Double[] value) {
        this.setValue(value);
    }

    public void setValueDoubleArray(double[] value) {
        this.setValue(JavaDatatypeUtils.boxDoubleArray(value));
    }

    public void setValueDoubleArray(float[] value) {
        this.setValue(JavaDatatypeUtils.boxFloatArray(value));
    }

    private void setValue(Object[] value) {
        if (value == null) {
            this.value = null;
            return;
        }
        this.value = new ArrayList<String>();
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) {
                this.value.add("");
                continue;
            }
            this.value.add(String.valueOf(value[i]));
        }
    }

    public List<String> getRawValue() {
        return this.value;
    }
}

