/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.model.value;

import info.rexs.model.util.Base64Utils;
import info.rexs.model.value.AbstractRexsAttributeValue;
import info.rexs.model.value.AbstractRexsAttributeValueArray;
import info.rexs.model.value.Base64Type;

public class RexsAttributeValueArrayBase64
extends AbstractRexsAttributeValueArray {
    private String value = null;
    private Base64Type type = null;

    public RexsAttributeValueArrayBase64() {
    }

    public RexsAttributeValueArrayBase64(String value, Base64Type type) {
        this.value = value;
        this.type = type;
    }

    @Override
    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    @Override
    public AbstractRexsAttributeValue copy() {
        return new RexsAttributeValueArrayBase64(this.value, this.type);
    }

    @Override
    public Integer[] getValueIntegerArray() {
        if (this.type == Base64Type.INT_32) {
            return Base64Utils.decodeInt32ArrayBoxed(this.value);
        }
        return super.getValueIntegerArray();
    }

    @Override
    public int[] getValueIntegerArrayUnboxed() {
        if (this.type == Base64Type.INT_32) {
            return Base64Utils.decodeInt32Array(this.value);
        }
        return super.getValueIntegerArrayUnboxed();
    }

    @Override
    public Double[] getValueDoubleArray() {
        if (this.type == Base64Type.FLOAT_32) {
            return Base64Utils.decodeFloat32ArrayBoxed(this.value);
        }
        if (this.type == Base64Type.FLOAT_64) {
            return Base64Utils.decodeFloat64ArrayBoxed(this.value);
        }
        return super.getValueDoubleArray();
    }

    @Override
    public double[] getValueDoubleArrayUnboxed() {
        if (this.type == Base64Type.FLOAT_32) {
            float[] floatArray = Base64Utils.decodeFloat32Array(this.value);
            return this.convertFloatArrayToDoubleArray(floatArray);
        }
        if (this.type == Base64Type.FLOAT_64) {
            return Base64Utils.decodeFloat64Array(this.value);
        }
        return super.getValueDoubleArrayUnboxed();
    }

    public void setValueIntegerArray(int[] value) {
        this.value = Base64Utils.encodeInt32Array(value);
        this.type = Base64Type.INT_32;
    }

    public void setValueDoubleArray(double[] value) {
        this.value = Base64Utils.encodeFloat64Array(value);
        this.type = Base64Type.FLOAT_64;
    }

    public void setValueDoubleArray(float[] value) {
        this.value = Base64Utils.encodeFloat32Array(value);
        this.type = Base64Type.FLOAT_32;
    }

    public String getRawValue() {
        return this.value;
    }

    public Base64Type getRawType() {
        return this.type;
    }
}

