/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.model.value;

import info.rexs.model.util.JavaDatatypeUtils;
import info.rexs.model.value.AbstractRexsAttributeValue;
import info.rexs.model.value.AbstractRexsAttributeValueMatrix;
import java.util.ArrayList;
import java.util.List;

public class RexsAttributeValueMatrix
extends AbstractRexsAttributeValueMatrix {
    private List<List<String>> value = null;

    public RexsAttributeValueMatrix() {
    }

    public RexsAttributeValueMatrix(List<List<String>> value) {
        this.value = value;
    }

    @Override
    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    @Override
    public AbstractRexsAttributeValue copy() {
        ArrayList<List<String>> value = null;
        if (this.value != null) {
            value = new ArrayList<List<String>>();
            for (List<String> rowValue : this.value) {
                value.add(new ArrayList<String>(rowValue));
            }
        }
        return new RexsAttributeValueMatrix(value);
    }

    @Override
    public Boolean[][] getValueBooleanMatrix() {
        Boolean[][] val = null;
        if (this.value != null && !this.value.isEmpty()) {
            val = this.convertStringMatrixToBooleanMatrix(this.value);
        }
        return val;
    }

    @Override
    public String[][] getValueStringMatrix() {
        String[][] val = null;
        if (this.value != null && !this.value.isEmpty()) {
            val = this.convertStringMatrixToStringMatrix(this.value);
        }
        return val;
    }

    @Override
    public Integer[][] getValueIntegerMatrix() {
        Integer[][] val = null;
        if (this.value != null && !this.value.isEmpty()) {
            val = this.convertStringMatrixToIntegerMatrixBoxed(this.value);
        }
        return val;
    }

    @Override
    public int[][] getValueIntegerMatrixUnboxed() {
        int[][] val = null;
        if (this.value != null && !this.value.isEmpty()) {
            val = this.convertStringMatrixToIntegerMatrixUnboxed(this.value);
        }
        return val;
    }

    @Override
    public Double[][] getValueDoubleMatrix() {
        Double[][] val = null;
        if (this.value != null && !this.value.isEmpty()) {
            val = this.convertStringMatrixToDoubleMatrixBoxed(this.value);
        }
        return val;
    }

    @Override
    public double[][] getValueDoubleMatrixUnboxed() {
        double[][] val = null;
        if (this.value != null && !this.value.isEmpty()) {
            val = this.convertStringMatrixToDoubleMatrixUnboxed(this.value);
        }
        return val;
    }

    public void setValueBooleanMatrix(Boolean[][] value) {
        this.setValue(value);
    }

    public void setValueStringMatrix(String[][] value) {
        this.setValue(value);
    }

    public void setValueIntegerMatrix(Integer[][] value) {
        this.setValue(value);
    }

    public void setValueIntegerMatrix(int[][] value) {
        this.setValue(JavaDatatypeUtils.boxIntMatrix(value));
    }

    public void setValueDoubleMatrix(Double[][] value) {
        this.setValue(value);
    }

    public void setValueDoubleMatrix(double[][] value) {
        this.setValue(JavaDatatypeUtils.boxDoubleMatrix(value));
    }

    public void setValueDoubleMatrix(float[][] value) {
        this.setValue(JavaDatatypeUtils.boxFloatMatrix(value));
    }

    private void setValue(Object[][] value) {
        if (value == null) {
            this.value = null;
            return;
        }
        this.value = new ArrayList<List<String>>();
        for (int i = 0; i < value.length; ++i) {
            ArrayList<String> row = new ArrayList<String>();
            if (value[i] != null) {
                for (int j = 0; j < value[i].length; ++j) {
                    if (value[i][j] == null) {
                        row.add("");
                        continue;
                    }
                    row.add(String.valueOf(value[i][j]));
                }
            }
            this.value.add(row);
        }
    }

    public List<List<String>> getRawValue() {
        return this.value;
    }
}

