/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.model.value;

import info.rexs.model.RexsModelAccessException;
import info.rexs.model.util.Base64Utils;
import info.rexs.model.value.AbstractRexsAttributeValue;
import info.rexs.model.value.AbstractRexsAttributeValueMatrix;
import info.rexs.model.value.Base64Type;

public class RexsAttributeValueMatrixBase64
extends AbstractRexsAttributeValueMatrix {
    private String value = null;
    private Base64Type type = null;
    private int rows = -1;
    private int cols = -1;

    public RexsAttributeValueMatrixBase64() {
    }

    public RexsAttributeValueMatrixBase64(String value, Base64Type type, int rows, int cols) {
        this.value = value;
        this.type = type;
        this.rows = rows;
        this.cols = cols;
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public AbstractRexsAttributeValue copy() {
        return new RexsAttributeValueMatrixBase64(this.value, this.type, this.rows, this.cols);
    }

    private void checkRowsAndCols() {
        if (this.rows < 0) {
            throw new RexsModelAccessException("matrix with base64 value requires number of rows");
        }
        if (this.cols < 0) {
            throw new RexsModelAccessException("matrix with base64 value requires number of columns");
        }
    }

    @Override
    public Integer[][] getValueIntegerMatrix() {
        this.checkRowsAndCols();
        if (this.type == Base64Type.INT_32) {
            return Base64Utils.decodeInt32MatrixBoxed(this.value, this.rows, this.cols);
        }
        return super.getValueIntegerMatrix();
    }

    @Override
    public int[][] getValueIntegerMatrixUnboxed() {
        this.checkRowsAndCols();
        if (this.type == Base64Type.INT_32) {
            return Base64Utils.decodeInt32Matrix(this.value, this.rows, this.cols);
        }
        return super.getValueIntegerMatrixUnboxed();
    }

    @Override
    public Double[][] getValueDoubleMatrix() {
        this.checkRowsAndCols();
        if (this.type == Base64Type.FLOAT_32) {
            return Base64Utils.decodeFloat32MatrixBoxed(this.value, this.rows, this.cols);
        }
        if (this.type == Base64Type.FLOAT_64) {
            return Base64Utils.decodeFloat64MatrixBoxed(this.value, this.rows, this.cols);
        }
        return super.getValueDoubleMatrix();
    }

    @Override
    public double[][] getValueDoubleMatrixUnboxed() {
        this.checkRowsAndCols();
        if (this.type == Base64Type.FLOAT_32) {
            float[][] floatMatrix = Base64Utils.decodeFloat32Matrix(this.value, this.rows, this.cols);
            return this.convertFloatMatrixToDoubleMatrix(floatMatrix);
        }
        if (this.type == Base64Type.FLOAT_64) {
            return Base64Utils.decodeFloat64Matrix(this.value, this.rows, this.cols);
        }
        return super.getValueDoubleMatrixUnboxed();
    }

    public void setValueIntegerMatrix(int[][] value) {
        this.value = Base64Utils.encodeInt32Matrix(value);
        this.type = Base64Type.INT_32;
        this.rows = value.length;
        if (this.rows > 0) {
            this.cols = value[0].length;
        }
    }

    public void setValueDoubleMatrix(double[][] value) {
        this.value = Base64Utils.encodeFloat64Matrix(value);
        this.type = Base64Type.FLOAT_64;
        this.rows = value.length;
        if (this.rows > 0) {
            this.cols = value[0].length;
        }
    }

    public void setValueDoubleMatrix(float[][] value) {
        this.value = Base64Utils.encodeFloat32Matrix(value);
        this.type = Base64Type.FLOAT_32;
        this.rows = value.length;
        if (this.rows > 0) {
            this.cols = value[0].length;
        }
    }

    public String getRawValue() {
        return this.value;
    }

    public Base64Type getRawType() {
        return this.type;
    }

    public int getRawRows() {
        return this.rows;
    }

    public int getRawCols() {
        return this.cols;
    }
}

