/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.upgrade.upgraders;

import info.rexs.db.constants.standard.RexsStandardVersions;
import info.rexs.model.RexsModel;
import info.rexs.upgrade.RexsUpgradeException;
import info.rexs.upgrade.upgraders.ModelChangelogUpgrader;
import info.rexs.upgrade.upgraders.ModelUpgraderResult;
import info.rexs.upgrade.upgraders.UpgradeNotifications;
import info.rexs.upgrade.upgraders.changelog.jaxb.RexsChangelogFile;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.InputStream;

public class ModelUpgraderV15toV16 {
    private static final String CHANGELOG_FILENAME = "/info/rexs/upgrade/upgraders/changelog/rexs_changelog_1.5_to_1.6.xml";
    private RexsModel newModel;
    private final RexsModel oldModel;
    private final boolean strictMode;
    private RexsChangelogFile.RexsChangelog changelog;
    private UpgradeNotifications notifications = new UpgradeNotifications();

    public ModelUpgraderV15toV16(RexsModel model, boolean strictMode) {
        this.oldModel = model;
        this.newModel = new RexsModel(model);
        this.strictMode = strictMode;
        try (InputStream stream = this.getClass().getResourceAsStream(CHANGELOG_FILENAME);){
            this.changelog = RexsChangelogFile.load(stream);
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        catch (JAXBException ex) {
            System.err.println((Object)ex);
        }
    }

    public ModelUpgraderResult doupgrade() throws RexsUpgradeException {
        ModelChangelogUpgrader changeLogUpgrader = new ModelChangelogUpgrader(this.newModel, this.changelog, this.strictMode);
        this.newModel = changeLogUpgrader.applyChangelog();
        this.notifications.addAll(changeLogUpgrader.getNotifications().getNotifications());
        this.newModel.setVersion(RexsStandardVersions.V1_6);
        this.newModel.setApplicationId("REXS API Upgrader");
        return new ModelUpgraderResult(this.newModel, this.notifications);
    }
}

