/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.upgrade.upgraders.changelog;

import info.rexs.db.constants.RexsVersion;
import info.rexs.db.constants.standard.RexsStandardVersions;
import info.rexs.upgrade.upgraders.changelog.ChangelogFileResolver;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

public class ChangelogFile {
    private static final ChangelogFileResolver DEFAULT_FILE_RESOLVER = new ChangelogFileResolver();
    private static Set<ChangelogFile> allChangelogFiles = new HashSet<ChangelogFile>();
    public static final ChangelogFile V1_0_TO_V1_1 = ChangelogFile.create(RexsStandardVersions.V1_0, RexsStandardVersions.V1_1);
    public static final ChangelogFile V1_1_TO_V1_2 = ChangelogFile.create(RexsStandardVersions.V1_1, RexsStandardVersions.V1_2);
    public static final ChangelogFile V1_2_TO_V1_3 = ChangelogFile.create(RexsStandardVersions.V1_2, RexsStandardVersions.V1_3);
    public static final ChangelogFile V1_3_TO_V1_4 = ChangelogFile.create(RexsStandardVersions.V1_3, RexsStandardVersions.V1_4);
    public static final ChangelogFile V1_4_TO_V1_5 = ChangelogFile.create(RexsStandardVersions.V1_4, RexsStandardVersions.V1_5);
    public static final ChangelogFile V1_5_TO_V1_6 = ChangelogFile.create(RexsStandardVersions.V1_5, RexsStandardVersions.V1_6);
    private final RexsVersion fromVersion;
    private final RexsVersion toVersion;
    private final ChangelogFileResolver fileResolver;

    private ChangelogFile(RexsVersion fromVersion, RexsVersion toVersion, ChangelogFileResolver fileResolver) {
        if (fromVersion == null) {
            throw new IllegalArgumentException("from version cannot be empty");
        }
        if (toVersion == null) {
            throw new IllegalArgumentException("to version cannot be empty");
        }
        this.fromVersion = fromVersion;
        this.toVersion = toVersion;
        this.fileResolver = fileResolver;
    }

    public RexsVersion getFromVersion() {
        return this.fromVersion;
    }

    public RexsVersion getToVersion() {
        return this.toVersion;
    }

    public InputStream openInputStream() {
        return this.fileResolver.openInputStream(this);
    }

    public static ChangelogFile create(RexsVersion fromVersion, RexsVersion toVersion, ChangelogFileResolver fileResolver) {
        if (fileResolver == null) {
            fileResolver = DEFAULT_FILE_RESOLVER;
        }
        ChangelogFile changelogFile = new ChangelogFile(fromVersion, toVersion, fileResolver);
        allChangelogFiles.add(changelogFile);
        return changelogFile;
    }

    public static ChangelogFile create(RexsVersion fromVersion, RexsVersion toVersion) {
        return ChangelogFile.create(fromVersion, toVersion, null);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangelogFile)) {
            return false;
        }
        ChangelogFile other = (ChangelogFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RexsVersion this_fromVersion = this.getFromVersion();
        RexsVersion other_fromVersion = other.getFromVersion();
        if (this_fromVersion == null ? other_fromVersion != null : !((Object)this_fromVersion).equals(other_fromVersion)) {
            return false;
        }
        RexsVersion this_toVersion = this.getToVersion();
        RexsVersion other_toVersion = other.getToVersion();
        return this_toVersion == null ? other_toVersion == null : ((Object)this_toVersion).equals(other_toVersion);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChangelogFile;
    }

    public int hashCode() {
        int result = 1;
        RexsVersion _fromVersion = this.getFromVersion();
        result = result * 59 + (_fromVersion == null ? 43 : ((Object)_fromVersion).hashCode());
        RexsVersion _toVersion = this.getToVersion();
        result = result * 59 + (_toVersion == null ? 43 : ((Object)_toVersion).hashCode());
        return result;
    }
}

