/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.validation;

import info.rexs.validation.RexsValidationResultMessage;
import info.rexs.validation.RexsValidationResultMessageKey;
import java.util.ArrayList;
import java.util.List;

public class RexsValidationResult {
    private List<RexsValidationResultMessage> warnings = new ArrayList<RexsValidationResultMessage>();
    private List<RexsValidationResultMessage> errors = new ArrayList<RexsValidationResultMessage>();

    public boolean isValid() {
        return this.errors == null || this.errors.isEmpty();
    }

    public void addError(RexsValidationResultMessageKey key, String ... additionalMessages) {
        this.errors.add(new RexsValidationResultMessage(key, additionalMessages));
    }

    public void addWarning(RexsValidationResultMessageKey key, String ... additionalMessages) {
        this.warnings.add(new RexsValidationResultMessage(key, additionalMessages));
    }

    public void add(RexsValidationResult validationResult) {
        this.errors.addAll(validationResult.getErrors());
        this.warnings.addAll(validationResult.getWarnings());
    }

    public List<RexsValidationResultMessage> getWarnings() {
        return this.warnings;
    }

    public List<RexsValidationResultMessage> getErrors() {
        return this.errors;
    }
}

