/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.validation;

import info.rexs.validation.DefaultRexsFileValidator;
import info.rexs.validation.DefaultRexsModelValidator;
import info.rexs.validation.IRexsFileValidator;
import info.rexs.validation.IRexsModelValidator;
import info.rexs.validation.RexsModellingGuidelineQuasistaticFileValidator;
import info.rexs.validation.RexsModellingGuidelineQuasistaticModelValidator;
import info.rexs.validation.RexsStandardFileValidator;
import info.rexs.validation.RexsStandardModelValidator;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum RexsValidatorMode {
    DEFAULT,
    STANDARD{

        @Override
        public IRexsFileValidator createFileValidator() {
            return new RexsStandardFileValidator();
        }

        @Override
        public IRexsModelValidator createModelValidator() {
            return new RexsStandardModelValidator();
        }
    }
    ,
    GUIDELINE_QUASI_STATIC{

        @Override
        public IRexsFileValidator createFileValidator() {
            return new RexsModellingGuidelineQuasistaticFileValidator();
        }

        @Override
        public IRexsModelValidator createModelValidator() {
            return new RexsModellingGuidelineQuasistaticModelValidator();
        }
    };


    public IRexsFileValidator createFileValidator() {
        return new DefaultRexsFileValidator();
    }

    public IRexsModelValidator createModelValidator() {
        return new DefaultRexsModelValidator();
    }
}

