/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaeqs.javayoutubedownloader.stream;

import io.github.gaeqs.javayoutubedownloader.tag.StreamType;
import io.github.gaeqs.javayoutubedownloader.util.HTMLUtils;
import io.github.gaeqs.javayoutubedownloader.util.Validate;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

public class StreamOption {
    private URL url;
    private StreamType type;

    public StreamOption(URL url, StreamType type) {
        Validate.notNull(url, "Url cannot be null!");
        Validate.notNull(type, "Type cannot be null!");
        this.url = url;
        this.type = type;
    }

    public URL getUrl() {
        return this.url;
    }

    public StreamType getType() {
        return this.type;
    }

    public String toString() {
        return "{Url:" + this.url + ", Stream: " + this.type.toString() + "}";
    }

    public boolean checkConnection() {
        HttpsURLConnection connection = null;
        try {
            connection = (HttpsURLConnection)this.url.openConnection();
            connection.setRequestProperty("User-Agent", HTMLUtils.USER_AGENT);
            connection.setDoInput(true);
            connection.connect();
            HTMLUtils.check(connection);
            connection.disconnect();
            return true;
        }
        catch (Exception ex) {
            if (connection != null) {
                try {
                    connection.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

