/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaeqs.javayoutubedownloader;

import io.github.gaeqs.javayoutubedownloader.decoder.Decoder;
import io.github.gaeqs.javayoutubedownloader.decoder.DecoderManager;
import io.github.gaeqs.javayoutubedownloader.decoder.MultipleDecoderMethod;
import io.github.gaeqs.javayoutubedownloader.stream.YoutubeVideo;
import io.github.gaeqs.javayoutubedownloader.tag.ITagMap;
import io.github.gaeqs.javayoutubedownloader.util.Validate;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;

public class JavaYoutubeDownloader {
    private static DecoderManager decoderManager = new DecoderManager();

    public static ITagMap getITagMap() {
        return ITagMap.MAP;
    }

    public static DecoderManager getDecoderManager() {
        return decoderManager;
    }

    public static YoutubeVideo decodeOrNull(String url, MultipleDecoderMethod method, String ... decoders) {
        try {
            return JavaYoutubeDownloader.decode(url, method, decoders);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static YoutubeVideo decodeOrNull(URL url, MultipleDecoderMethod method, String ... decoders) {
        try {
            return JavaYoutubeDownloader.decode(url, method, decoders);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static YoutubeVideo decode(String url, MultipleDecoderMethod method, String ... decoders) throws MalformedURLException {
        Validate.notNull(url, "url cannot be null!");
        return JavaYoutubeDownloader.decode(new URL(url), method, decoders);
    }

    public static YoutubeVideo decode(URL url, MultipleDecoderMethod method, String ... decoders) {
        Validate.notNull(url, "url cannot be null!");
        Validate.notNull((Object)method, "method cannot be null!");
        Validate.notNull(decoders, "decoders cannot be null!");
        if (decoders.length == 0) {
            throw new IllegalArgumentException("There are no decoders defined!");
        }
        YoutubeVideo video = null;
        for (String string : decoders) {
            YoutubeVideo current;
            Optional<Decoder> decoder = decoderManager.getDecoder(string);
            if (!decoder.isPresent()) continue;
            try {
                current = decoder.get().extractVideo(url);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            if (video == null) {
                video = current;
            } else {
                video.merge(current);
            }
            if (video.getStreamOptions().isEmpty() || method != MultipleDecoderMethod.OR) continue;
            return video;
        }
        if (video == null) {
            throw new IllegalStateException("Couldn't get any video instance");
        }
        return video;
    }
}

