/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaeqs.javayoutubedownloader.stream;

import io.github.gaeqs.javayoutubedownloader.JavaYoutubeDownloader;
import io.github.gaeqs.javayoutubedownloader.decrypt.Decrypt;
import io.github.gaeqs.javayoutubedownloader.decrypt.HTML5SignatureDecrypt;
import io.github.gaeqs.javayoutubedownloader.exception.StreamEncodedException;
import io.github.gaeqs.javayoutubedownloader.stream.StreamOption;
import io.github.gaeqs.javayoutubedownloader.tag.StreamType;
import io.github.gaeqs.javayoutubedownloader.util.Validate;
import java.net.URL;
import java.util.Optional;

public class EncodedStream {
    private static final String DEFAULT_JS_SCRIPT = "https://youtube.com/yts/jsbin/player_ias-vflEO2H8R/en_US/base.js";
    private static final String SIGNATURE_PARAMETER = "&sig=";
    private static final Decrypt DECRYPT = new HTML5SignatureDecrypt();
    private final int iTag;
    private final String url;
    private final String signature;
    private StreamOption decodedStream;

    public EncodedStream(int iTag, String url) {
        this(iTag, url, null);
    }

    public EncodedStream(int iTag, String url, String signature) {
        Validate.notNull(url, "url cannot be null!");
        this.iTag = iTag;
        this.url = url;
        this.signature = signature;
        this.decodedStream = null;
    }

    public int getITag() {
        return this.iTag;
    }

    public String getUrl() {
        return this.url;
    }

    public Optional<String> getSignature() {
        return Optional.ofNullable(this.signature);
    }

    public boolean hasSignature() {
        return this.signature != null;
    }

    public StreamOption getDecodedStream() {
        if (this.decodedStream == null) {
            throw new StreamEncodedException();
        }
        return this.decodedStream;
    }

    public boolean decode(String jsUrl, boolean checkConnection) {
        if (this.decodedStream != null) {
            return true;
        }
        boolean created = !this.hasSignature() ? this.decodeSimple() : this.decodeComplex(jsUrl);
        if (!created) {
            return false;
        }
        if (!checkConnection) {
            return true;
        }
        if (!this.decodedStream.checkConnection()) {
            System.out.println("Error checking connection! (Signature not working)\n" + this.decodedStream.getUrl());
            this.decodedStream = null;
            return false;
        }
        return true;
    }

    private boolean decodeSimple() {
        try {
            this.decodedStream = new StreamOption(new URL(this.url), (StreamType)JavaYoutubeDownloader.getITagMap().get(this.iTag));
            return true;
        }
        catch (IllegalArgumentException ex) {
            if (JavaYoutubeDownloader.getITagMap().get(this.iTag) == null) {
                if (this.iTag > 393 && this.iTag <= 399) {
                    return false;
                }
                System.err.println("Couldn't find the StreamType for the iTag " + this.iTag);
            } else {
                ex.printStackTrace();
            }
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private boolean decodeComplex(String jsUrl) {
        String decryptedSignature = DECRYPT.decrypt(jsUrl == null ? DEFAULT_JS_SCRIPT : jsUrl, this.signature);
        try {
            this.decodedStream = new StreamOption(new URL(this.url + SIGNATURE_PARAMETER + decryptedSignature), (StreamType)JavaYoutubeDownloader.getITagMap().get(this.iTag));
        }
        catch (IllegalArgumentException ex) {
            if (JavaYoutubeDownloader.getITagMap().get(this.iTag) == null) {
                if (this.iTag > 393 && this.iTag <= 399) {
                    return false;
                }
                System.err.println("Couldn't find the StreamType for the iTag " + this.iTag);
            } else {
                ex.printStackTrace();
            }
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }
}

