/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaeqs.javayoutubedownloader.util;

import com.alibaba.fastjson.JSONObject;
import io.github.gaeqs.javayoutubedownloader.stream.EncodedStream;
import io.github.gaeqs.javayoutubedownloader.util.NumericUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;

public class EncodedStreamUtils {
    public static void addEncodedStreams(String encodedString, Collection<EncodedStream> collection, String urlEncoding) throws UnsupportedEncodingException {
        String[] streams = encodedString.trim().split(",");
        String url = null;
        String encoding = null;
        int iTag = -1;
        for (String stream : streams) {
            String[] pairs;
            block11: for (String pair : pairs = stream.split("&")) {
                String key;
                int idx = pair.indexOf(61);
                if (idx == -1) continue;
                switch (key = URLDecoder.decode(pair.substring(0, idx).toLowerCase(), urlEncoding)) {
                    case "url": {
                        url = URLDecoder.decode(pair.substring(idx + 1), urlEncoding);
                        continue block11;
                    }
                    case "s": {
                        encoding = URLDecoder.decode(pair.substring(idx + 1), urlEncoding);
                        continue block11;
                    }
                    case "itag": {
                        key = URLDecoder.decode(pair.substring(idx + 1), urlEncoding);
                        if (!NumericUtils.isInteger(key)) continue block11;
                        iTag = Integer.valueOf(key);
                    }
                }
            }
            if (iTag == -1 || url == null) continue;
            collection.add(new EncodedStream(iTag, url, encoding));
        }
    }

    public static void addEncodedStreams(JSONObject json, Collection<EncodedStream> collection, String urlEnconding) throws UnsupportedEncodingException {
        int iTag = json.getInteger("itag");
        if (json.containsKey((Object)"signatureCipher")) {
            String cipher = json.getString("signatureCipher").replace("\\u0026", "&");
            String[] pairs = cipher.split("&");
            String encodedUrl = null;
            String signature = null;
            for (String pair : pairs) {
                int equalsIndex = pair.indexOf(61);
                String key = pair.substring(0, equalsIndex);
                String value = pair.substring(equalsIndex + 1);
                if (key.equals("url")) {
                    encodedUrl = value;
                    continue;
                }
                if (!key.equals("s")) continue;
                signature = value;
            }
            if (encodedUrl == null) {
                System.err.println("Encoded URL is null.");
                return;
            }
            if (!((encodedUrl = URLDecoder.decode(encodedUrl, urlEnconding)).contains("signature") || encodedUrl.contains("&sig=") || encodedUrl.contains("&lsign="))) {
                if (signature != null) {
                    signature = URLDecoder.decode(signature, urlEnconding);
                }
                collection.add(new EncodedStream(iTag, encodedUrl, signature));
            } else {
                collection.add(new EncodedStream(iTag, encodedUrl));
            }
        } else {
            if (!json.containsKey((Object)"url")) {
                return;
            }
            collection.add(new EncodedStream(iTag, json.getString("url")));
        }
    }
}

