/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaeqs.javayoutubedownloader.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HTMLUtils {
    public static String USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:97.0) Gecko/20100101 Firefox/97.0";

    public static String readAll(URL url) throws IOException {
        String line;
        URLConnection connection = url.openConnection();
        connection.setRequestProperty("User-Agent", USER_AGENT);
        connection.setDoInput(true);
        InputStream is = connection.getInputStream();
        String enc = connection.getContentEncoding();
        if (enc == null) {
            Pattern p = Pattern.compile("charset=(.*)");
            Matcher m = p.matcher(connection.getHeaderField("Content-Type"));
            enc = m.find() ? m.group(1) : "UTF-8";
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, enc));
        StringBuilder html = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            html.append(line).append("\n");
            if (!Thread.currentThread().isInterrupted()) continue;
            throw new RuntimeException("HTML download has been interrupted.");
        }
        return html.toString();
    }

    public static void check(HttpURLConnection c) throws IOException {
        int code = c.getResponseCode();
        String message = c.getResponseMessage();
        switch (code) {
            case 200: 
            case 206: {
                return;
            }
            case 301: 
            case 302: {
                throw new RuntimeException("Download moved (" + message + ")");
            }
            case 407: {
                throw new RuntimeException("Proxy auth (" + message + ")");
            }
            case 403: {
                throw new RuntimeException("Http forbidden: " + code + " (" + message + ")");
            }
            case 416: {
                throw new RuntimeException("Requested range nt satisfiable (" + message + ")");
            }
        }
    }
}

