/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaeqs.javayoutubedownloader.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.github.gaeqs.javayoutubedownloader.stream.EncodedStream;
import io.github.gaeqs.javayoutubedownloader.util.EncodedStreamUtils;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;

public class PlayerResponseUtils {
    public static final String STREAMING_DATA_JSON_PARAMETER = "streamingData";
    public static final String FORMATS_JSON_PARAMETER = "formats";

    public static void addPlayerResponseStreams(String json, Collection<EncodedStream> streams, String urlEncoding) {
        JSONObject obj = JSONObject.parseObject((String)json);
        if (obj.containsKey((Object)STREAMING_DATA_JSON_PARAMETER) && (obj = obj.getJSONObject(STREAMING_DATA_JSON_PARAMETER)).containsKey((Object)FORMATS_JSON_PARAMETER)) {
            PlayerResponseUtils.addJSONStreams(obj.getJSONArray(FORMATS_JSON_PARAMETER), streams, urlEncoding);
        }
    }

    private static void addJSONStreams(JSONArray array, Collection<EncodedStream> streams, String urlEncoding) {
        array.forEach(target -> {
            if (!(target instanceof JSONObject)) {
                return;
            }
            JSONObject obj = (JSONObject)target;
            try {
                if (obj.containsKey((Object)"cipher")) {
                    ArrayList<EncodedStream> list = new ArrayList<EncodedStream>();
                    EncodedStreamUtils.addEncodedStreams(URLDecoder.decode(obj.getString("signatureCipher"), urlEncoding), list, urlEncoding);
                    list.forEach(stream -> System.out.println(stream.getUrl() + "\n - " + (String)stream.getSignature().orElse(null)));
                    streams.addAll(list);
                }
                if (obj.containsKey((Object)"url")) {
                    int iTag = obj.getInteger("itag");
                    String url = URLDecoder.decode(obj.getString("url"), urlEncoding);
                    streams.add(new EncodedStream(iTag, url));
                }
            }
            catch (Exception e) {
                System.err.println(obj);
                System.err.println("Error while parsing url.");
                e.printStackTrace();
            }
        });
    }
}

