/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaeqs.javayoutubedownloader.decoder;

import io.github.gaeqs.javayoutubedownloader.decoder.Decoder;
import io.github.gaeqs.javayoutubedownloader.decoder.EmbeddedDecoder;
import io.github.gaeqs.javayoutubedownloader.decoder.HTMLDecoder;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class DecoderManager {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private Map<String, Decoder> decoders = new ConcurrentHashMap<String, Decoder>();

    public DecoderManager() {
        this.loadDefaults();
    }

    private void loadDefaults() {
        this.decoders.put("html", new HTMLDecoder(DEFAULT_ENCODING));
        this.decoders.put("embedded", new EmbeddedDecoder(DEFAULT_ENCODING));
    }

    public Optional<Decoder> getDecoder(String name) {
        return Optional.ofNullable(this.decoders.get(name));
    }

    public void addDecoder(String name, Decoder decoder) {
        this.decoders.put(name, decoder);
    }

    public Map<String, Decoder> getDecoders() {
        return this.decoders;
    }
}

