/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaeqs.javayoutubedownloader.decoder;

import io.github.gaeqs.javayoutubedownloader.decoder.Decoder;
import io.github.gaeqs.javayoutubedownloader.exception.EmbeddedExtractionException;
import io.github.gaeqs.javayoutubedownloader.stream.EncodedStream;
import io.github.gaeqs.javayoutubedownloader.stream.YoutubeVideo;
import io.github.gaeqs.javayoutubedownloader.util.EncodedStreamUtils;
import io.github.gaeqs.javayoutubedownloader.util.HTMLUtils;
import io.github.gaeqs.javayoutubedownloader.util.IdExtractor;
import io.github.gaeqs.javayoutubedownloader.util.PlayerResponseUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class EmbeddedDecoder
implements Decoder {
    public static final String DEFAULT_GET_VIDEO_URL = "https://www.youtube.com/get_video_info?video_id=%s";
    public static final String TITLE_PARAMETER = "title";
    public static final String AUTHOR_PARAMETER = "author";
    public static final String MUXED_STREAM_LIST_PARAMETER = "url_encoded_fmt_stream_map";
    public static final String ADAPTIVE_STREAM_LIST_PARAMETER = "adaptive_fmts";
    public static final String PLAYER_RESPONSE_LIST_PARAMETER = "player_response";
    private String urlEncoding;
    private String getVideoUrl;

    public EmbeddedDecoder(String urlEncoding) {
        this.urlEncoding = urlEncoding;
        this.getVideoUrl = DEFAULT_GET_VIDEO_URL;
    }

    public EmbeddedDecoder(String urlEncoding, String getVideoUrl) {
        this.urlEncoding = urlEncoding;
        this.getVideoUrl = getVideoUrl;
    }

    public String getUrlEncoding() {
        return this.urlEncoding;
    }

    public void setUrlEncoding(String urlEncoding) {
        this.urlEncoding = urlEncoding;
    }

    public String getGetVideoUrl() {
        return this.getVideoUrl;
    }

    public void setGetVideoUrl(String getVideoUrl) {
        this.getVideoUrl = getVideoUrl;
    }

    @Override
    public YoutubeVideo extractVideo(URL url) throws IOException {
        URL embeddedUrl = new URL(String.format(this.getVideoUrl, IdExtractor.extractId(url.toExternalForm())));
        String query = HTMLUtils.readAll(embeddedUrl);
        Map<String, String> queryData = this.getQueryMap(query);
        this.checkExceptions(queryData);
        String title = queryData.containsKey(TITLE_PARAMETER) ? this.decode(queryData.get(TITLE_PARAMETER)) : "null";
        String author = queryData.containsKey(AUTHOR_PARAMETER) ? this.decode(queryData.get(AUTHOR_PARAMETER)) : "null";
        YoutubeVideo video = new YoutubeVideo(title, author);
        LinkedList<EncodedStream> encodedStreams = new LinkedList<EncodedStream>();
        if (queryData.containsKey(PLAYER_RESPONSE_LIST_PARAMETER)) {
            PlayerResponseUtils.addPlayerResponseStreams(this.decode(queryData.get(PLAYER_RESPONSE_LIST_PARAMETER)), encodedStreams, this.urlEncoding);
        }
        if (queryData.containsKey(MUXED_STREAM_LIST_PARAMETER)) {
            String encodedMuxedStreamList = this.decode(queryData.get(MUXED_STREAM_LIST_PARAMETER));
            EncodedStreamUtils.addEncodedStreams(encodedMuxedStreamList, encodedStreams, this.urlEncoding);
        }
        if (queryData.containsKey(ADAPTIVE_STREAM_LIST_PARAMETER)) {
            String encodedAdaptiveStreamList = this.decode(queryData.get(ADAPTIVE_STREAM_LIST_PARAMETER));
            EncodedStreamUtils.addEncodedStreams(encodedAdaptiveStreamList, encodedStreams, this.urlEncoding);
        }
        encodedStreams.removeIf(target -> !target.decode(null, true));
        encodedStreams.forEach(target -> video.getStreamOptions().add(target.getDecodedStream()));
        return video;
    }

    private Map<String, String> getQueryMap(String query) {
        String[] pairs;
        HashMap<String, String> map = new HashMap<String, String>();
        query = query.trim();
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            map.put(this.decode(pair.substring(0, idx)), pair.substring(idx + 1));
        }
        return map;
    }

    private String checkExceptions(Map<String, String> queryMap) {
        String status = queryMap.get("status");
        if (status.equals("fail")) {
            String error = queryMap.get("errorcode");
            String reason = queryMap.get("reason");
            if (error.equals("150")) {
                throw new EmbeddedExtractionException("Embedding is disabled. Error code " + error + ". Reason: " + reason);
            }
            if (error.equals("100")) {
                throw new EmbeddedExtractionException("Video has been deleted. Error code " + error + ". Reason: " + reason);
            }
            throw new EmbeddedExtractionException("Error code " + error + ". Reason: " + reason);
        }
        return status;
    }

    private String decode(String string) {
        try {
            return URLDecoder.decode(string, this.urlEncoding);
        }
        catch (UnsupportedEncodingException | NullPointerException e) {
            System.err.println("Error while decoding string " + string);
            e.printStackTrace();
            return string;
        }
    }
}

