/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaeqs.javayoutubedownloader.stream;

import io.github.gaeqs.javayoutubedownloader.stream.StreamOption;
import io.github.gaeqs.javayoutubedownloader.util.Validate;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class YoutubeVideo {
    private String title;
    private String author;
    private List<StreamOption> streamOptions;

    public YoutubeVideo(String title, String author) {
        this(title, author, null);
    }

    public YoutubeVideo(String title, String author, List<StreamOption> streamOptions) {
        Validate.notNull(title, "Title cannot be null!");
        this.title = title;
        this.author = author;
        this.streamOptions = streamOptions == null ? new LinkedList() : streamOptions;
    }

    public String getTitle() {
        return this.title;
    }

    public Optional<String> getAuthor() {
        return Optional.ofNullable(this.author);
    }

    public List<StreamOption> getStreamOptions() {
        return this.streamOptions;
    }

    public void merge(YoutubeVideo video) {
        this.streamOptions.addAll(video.streamOptions);
    }
}

