/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaeqs.javayoutubedownloader.stream.download;

import io.github.gaeqs.javayoutubedownloader.exception.DownloadException;
import io.github.gaeqs.javayoutubedownloader.stream.StreamOption;
import io.github.gaeqs.javayoutubedownloader.stream.download.DownloadStatus;
import io.github.gaeqs.javayoutubedownloader.stream.download.StreamDownloaderNotifier;
import io.github.gaeqs.javayoutubedownloader.util.HTMLUtils;
import io.github.gaeqs.javayoutubedownloader.util.Validate;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;

public class StreamDownloader
implements Runnable {
    private static final int BUFFER_SIZE = 4096;
    private StreamOption option;
    private File target;
    private StreamDownloaderNotifier notifier;
    private int length;
    private int count;
    private DownloadStatus status;

    public StreamDownloader(StreamOption option, File target, StreamDownloaderNotifier notifier) {
        Validate.notNull(option, "Option cannot be null!");
        Validate.notNull(target, "Target cannot be null!");
        this.option = option;
        this.target = target;
        this.notifier = notifier;
        this.length = 0;
        this.count = 0;
        this.status = DownloadStatus.READY;
    }

    public StreamOption getOption() {
        return this.option;
    }

    public File getTarget() {
        return this.target;
    }

    public StreamDownloaderNotifier getNotifier() {
        return this.notifier;
    }

    public void setNotifier(StreamDownloaderNotifier notifier) {
        this.notifier = notifier;
    }

    public int getLength() {
        return this.length;
    }

    public int getCount() {
        return this.count;
    }

    public DownloadStatus getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.status == DownloadStatus.DOWNLOADING) {
            throw new RuntimeException("This downloader is already running!");
        }
        this.status = DownloadStatus.DOWNLOADING;
        RandomAccessFile randomAccessFile = null;
        try {
            int read;
            HttpURLConnection connection = (HttpURLConnection)this.option.getUrl().openConnection();
            connection.setRequestProperty("User-Agent", HTMLUtils.USER_AGENT);
            connection.setDoInput(true);
            if (!this.target.createNewFile()) {
                throw new DownloadException("File couldn't be created");
            }
            randomAccessFile = new RandomAccessFile(this.target, "rw");
            byte[] bytes = new byte[4096];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(connection.getInputStream());
            HTMLUtils.check(connection);
            this.length = connection.getContentLength();
            this.count = 0;
            if (this.notifier != null) {
                this.notifier.onStart(this);
            }
            while ((read = bufferedInputStream.read(bytes)) > 0) {
                randomAccessFile.write(bytes, 0, read);
                this.count += read;
                if (this.notifier != null) {
                    this.notifier.onDownload(this);
                }
                if (!Thread.interrupted()) continue;
                throw new DownloadException("Thread interrupted");
            }
            bufferedInputStream.close();
            if (this.notifier != null) {
                this.notifier.onFinish(this);
            }
        }
        catch (Exception ex) {
            if (this.notifier != null) {
                this.notifier.onError(this, ex);
            }
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

