/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaeqs.javayoutubedownloader.tag;

import io.github.gaeqs.javayoutubedownloader.tag.AudioQuality;
import io.github.gaeqs.javayoutubedownloader.tag.Container;
import io.github.gaeqs.javayoutubedownloader.tag.Encoding;
import io.github.gaeqs.javayoutubedownloader.tag.FPS;
import io.github.gaeqs.javayoutubedownloader.tag.FormatNote;
import io.github.gaeqs.javayoutubedownloader.tag.VideoQuality;

public class StreamType {
    private Container container;
    private Encoding videoEncoding;
    private Encoding audioEncoding;
    private VideoQuality videoQuality;
    private AudioQuality audioQuality;
    private FormatNote formatNote;
    private FPS fps;

    public StreamType(Container container, Encoding videoEncoding, VideoQuality videoQuality, Encoding audioEncoding, AudioQuality audioQuality, FormatNote formatNote) {
        this.container = container;
        this.videoEncoding = videoEncoding;
        this.videoQuality = videoQuality;
        this.audioEncoding = audioEncoding;
        this.audioQuality = audioQuality;
        this.formatNote = formatNote;
        this.fps = FPS.f30;
    }

    public StreamType(Container container, Encoding videoEncoding, VideoQuality videoQuality, FormatNote formatNote) {
        this.container = container;
        this.videoEncoding = videoEncoding;
        this.videoQuality = videoQuality;
        this.audioEncoding = null;
        this.audioQuality = null;
        this.formatNote = formatNote;
        this.fps = FPS.f30;
    }

    public StreamType(Container container, Encoding audioEncoding, AudioQuality audioQuality, FormatNote formatNote) {
        this.container = container;
        this.audioEncoding = audioEncoding;
        this.audioQuality = audioQuality;
        this.videoEncoding = null;
        this.videoQuality = null;
        this.formatNote = formatNote;
        this.fps = FPS.f30;
    }

    public StreamType(Container container, Encoding videoEncoding, VideoQuality videoQuality, Encoding audioEncoding, AudioQuality audioQuality, FormatNote formatNote, FPS fps) {
        this.container = container;
        this.videoEncoding = videoEncoding;
        this.videoQuality = videoQuality;
        this.audioEncoding = audioEncoding;
        this.audioQuality = audioQuality;
        this.formatNote = formatNote;
        this.fps = fps;
    }

    public StreamType(Container container, Encoding videoEncoding, VideoQuality videoQuality, FormatNote formatNote, FPS fps) {
        this.container = container;
        this.videoEncoding = videoEncoding;
        this.videoQuality = videoQuality;
        this.audioEncoding = null;
        this.audioQuality = null;
        this.formatNote = formatNote;
        this.fps = fps;
    }

    public StreamType(Container container, Encoding audioEncoding, AudioQuality audioQuality, FormatNote formatNote, FPS fps) {
        this.container = container;
        this.audioEncoding = audioEncoding;
        this.audioQuality = audioQuality;
        this.videoEncoding = null;
        this.videoQuality = null;
        this.formatNote = formatNote;
        this.fps = fps;
    }

    public Container getContainer() {
        return this.container;
    }

    public Encoding getVideoEncoding() {
        return this.videoEncoding;
    }

    public Encoding getAudioEncoding() {
        return this.audioEncoding;
    }

    public VideoQuality getVideoQuality() {
        return this.videoQuality;
    }

    public AudioQuality getAudioQuality() {
        return this.audioQuality;
    }

    public FormatNote getFormatNote() {
        return this.formatNote;
    }

    public FPS getFps() {
        return this.fps;
    }

    public boolean hasVideo() {
        return this.videoQuality != null && this.videoEncoding != null;
    }

    public boolean hasAudio() {
        return this.audioQuality != null && this.audioEncoding != null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[Video: " + this.hasVideo() + ", Audio: " + this.hasAudio() + ", Container: " + (Object)((Object)this.container));
        if (this.hasVideo()) {
            builder.append(", VEncoding: ").append((Object)this.videoEncoding).append(", VQuality: ").append((Object)this.videoQuality);
        }
        if (this.hasAudio()) {
            builder.append(", AEncoding: ").append((Object)this.audioEncoding).append(", AQuality: ").append((Object)this.audioQuality);
        }
        builder.append(", Format Note: ").append((Object)this.formatNote).append(", FPS: ").append((Object)this.fps).append("]");
        return builder.toString();
    }
}

