/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.typeBuilders;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.exceptions.GraphQLAnnotationsException;
import graphql.annotations.processor.retrievers.GraphQLFieldRetriever;
import graphql.annotations.processor.retrievers.GraphQLObjectInfoRetriever;
import graphql.annotations.processor.searchAlgorithms.SearchAlgorithm;
import graphql.annotations.processor.util.ObjectUtil;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class InputObjectBuilder {
    private GraphQLObjectInfoRetriever graphQLObjectInfoRetriever;
    private SearchAlgorithm fieldSearchAlgorithm;
    private SearchAlgorithm methodSearchAlgorithm;
    private GraphQLFieldRetriever graphQLFieldRetriever;

    public InputObjectBuilder(GraphQLObjectInfoRetriever graphQLObjectInfoRetriever, SearchAlgorithm fieldSearchAlgorithm, SearchAlgorithm methodSearchAlgorithm, GraphQLFieldRetriever graphQLFieldRetriever) {
        this.graphQLObjectInfoRetriever = graphQLObjectInfoRetriever;
        this.methodSearchAlgorithm = methodSearchAlgorithm;
        this.fieldSearchAlgorithm = fieldSearchAlgorithm;
        this.graphQLFieldRetriever = graphQLFieldRetriever;
    }

    public GraphQLInputObjectType.Builder getInputObjectBuilder(Class<?> object, ProcessingElementsContainer container) throws GraphQLAnnotationsException {
        GraphQLInputObjectField gqlField;
        GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject();
        builder.name(container.getInputPrefix() + this.graphQLObjectInfoRetriever.getTypeName(object) + container.getInputSuffix());
        GraphQLDescription description = object.getAnnotation(GraphQLDescription.class);
        if (description != null) {
            builder.description(description.value());
        }
        ArrayList<String> definedFields = new ArrayList<String>();
        for (Method method : this.graphQLObjectInfoRetriever.getOrderedMethods(object)) {
            if (method.isBridge() || method.isSynthetic() || !this.methodSearchAlgorithm.isFound(method)) continue;
            gqlField = this.graphQLFieldRetriever.getInputField(method, container);
            definedFields.add(gqlField.getName());
            builder.field(gqlField);
        }
        for (Field field : ObjectUtil.getAllFields(object).values()) {
            if (Modifier.isStatic(field.getModifiers()) || !this.fieldSearchAlgorithm.isFound(field)) continue;
            gqlField = this.graphQLFieldRetriever.getInputField(field, container);
            definedFields.add(gqlField.getName());
            builder.field(gqlField);
        }
        return builder;
    }
}

