/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.characteristics.impl.airquality;

import io.github.hapjava.characteristics.CharacteristicEnum;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum AirQualityEnum implements CharacteristicEnum
{
    UNKNOWN(0),
    EXCELLENT(1),
    GOOD(2),
    FAIR(3),
    INFERIOR(4),
    POOR(5);

    private static final Map<Integer, AirQualityEnum> reverse;
    private final int code;

    public static AirQualityEnum fromCode(Integer code) {
        return reverse.get(code);
    }

    private AirQualityEnum(int code) {
        this.code = code;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    static {
        reverse = Arrays.stream(AirQualityEnum.values()).collect(Collectors.toMap(AirQualityEnum::getCode, t -> t));
    }
}

