/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.characteristics.impl.base;

import io.github.hapjava.characteristics.Characteristic;
import io.github.hapjava.characteristics.EventableCharacteristic;
import io.github.hapjava.characteristics.HomekitCharacteristicChangeCallback;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCharacteristic<T>
implements Characteristic,
EventableCharacteristic {
    private final Logger logger = LoggerFactory.getLogger(BaseCharacteristic.class);
    private final String type;
    private final String shortType;
    private final String format;
    private final String description;
    private final boolean isReadable;
    private final boolean isWritable;
    private final Optional<Consumer<HomekitCharacteristicChangeCallback>> subscriber;
    private final Optional<Runnable> unsubscriber;

    public BaseCharacteristic(String type, String format, String description, boolean isReadable, boolean isWritable, Optional<Consumer<HomekitCharacteristicChangeCallback>> subscriber, Optional<Runnable> unsubscriber) {
        if (type == null || format == null || description == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.shortType = this.type.replaceAll("^0*([0-9a-fA-F]+)-0000-1000-8000-0026BB765291$", "$1");
        this.format = format;
        this.description = description;
        this.isReadable = isReadable;
        this.isWritable = isWritable;
        this.subscriber = subscriber;
        this.unsubscriber = unsubscriber;
    }

    @Override
    public final CompletableFuture<JsonObject> toJson(int iid) {
        return this.makeBuilder(iid).thenApply(builder -> builder.build());
    }

    protected CompletableFuture<JsonObjectBuilder> makeBuilder(int instanceId) {
        CompletableFuture<T> futureValue = this.getValue();
        if (futureValue == null) {
            futureValue = CompletableFuture.completedFuture(this.getDefault());
        }
        return ((CompletableFuture)futureValue.exceptionally(t -> {
            this.logger.warn("Could not retrieve value " + this.getClass().getName(), t);
            return null;
        })).thenApply(value -> {
            JsonArrayBuilder perms = Json.createArrayBuilder();
            if (this.isReadable) {
                perms.add("pr");
            }
            if (this.isWritable) {
                perms.add("pw");
            }
            if (this.subscriber.isPresent()) {
                perms.add("ev");
            }
            JsonObjectBuilder builder = Json.createObjectBuilder().add("iid", instanceId).add("type", this.shortType).add("perms", (JsonValue)perms.build()).add("format", this.format).add("description", this.description);
            if (this.isReadable) {
                this.setJsonValue(builder, value);
            }
            return builder;
        });
    }

    @Override
    public final void setValue(JsonValue jsonValue) {
        try {
            this.setValue(this.convert(jsonValue));
        }
        catch (Exception e) {
            this.logger.warn("Error while setting JSON value", (Throwable)e);
        }
    }

    @Override
    public void supplyValue(JsonObjectBuilder builder) {
        try {
            this.setJsonValue(builder, this.getValue().get());
        }
        catch (InterruptedException | ExecutionException e) {
            this.logger.warn("Error retrieving value", (Throwable)e);
            this.setJsonValue(builder, this.getDefault());
        }
    }

    @Override
    public void subscribe(HomekitCharacteristicChangeCallback callback) {
        this.subscriber.get().accept(callback);
    }

    @Override
    public void unsubscribe() {
        this.unsubscriber.get().run();
    }

    protected abstract T convert(JsonValue var1);

    protected abstract void setValue(T var1) throws Exception;

    protected abstract CompletableFuture<T> getValue();

    protected abstract T getDefault();

    protected void setJsonValue(JsonObjectBuilder builder, T value) {
        if (value instanceof Boolean) {
            builder.add("value", ((Boolean)value).booleanValue());
        } else if (value instanceof Double) {
            builder.add("value", ((Double)value).doubleValue());
        } else if (value instanceof Integer) {
            builder.add("value", ((Integer)value).intValue());
        } else if (value instanceof Long) {
            builder.add("value", ((Long)value).longValue());
        } else if (value instanceof BigInteger) {
            builder.add("value", (BigInteger)value);
        } else if (value instanceof BigDecimal) {
            builder.add("value", (BigDecimal)value);
        } else if (value == null) {
            builder.addNull("value");
        } else {
            builder.add("value", value.toString());
        }
    }
}

