/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.characteristics.impl.base;

import io.github.hapjava.characteristics.ExceptionalConsumer;
import io.github.hapjava.characteristics.HomekitCharacteristicChangeCallback;
import io.github.hapjava.characteristics.impl.base.BaseCharacteristic;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.json.JsonNumber;
import javax.json.JsonValue;

public abstract class BooleanCharacteristic
extends BaseCharacteristic<Boolean> {
    private final Optional<Supplier<CompletableFuture<Boolean>>> getter;
    private final Optional<ExceptionalConsumer<Boolean>> setter;

    public BooleanCharacteristic(String type, String description, Optional<Supplier<CompletableFuture<Boolean>>> getter, Optional<ExceptionalConsumer<Boolean>> setter, Optional<Consumer<HomekitCharacteristicChangeCallback>> subscriber, Optional<Runnable> unsubscriber) {
        super(type, "bool", description, getter.isPresent(), setter.isPresent(), subscriber, unsubscriber);
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    protected Boolean convert(JsonValue jsonValue) {
        if (jsonValue.getValueType().equals((Object)JsonValue.ValueType.NUMBER)) {
            return ((JsonNumber)jsonValue).intValue() > 0;
        }
        return jsonValue.equals(JsonValue.TRUE);
    }

    @Override
    protected CompletableFuture<Boolean> getValue() {
        return this.getter.isPresent() ? this.getter.map(booleanGetter -> (CompletableFuture)booleanGetter.get()).get() : null;
    }

    @Override
    protected void setValue(Boolean value) throws Exception {
        if (this.setter.isPresent()) {
            this.setter.get().accept(value);
        }
    }

    @Override
    protected Boolean getDefault() {
        return false;
    }
}

