/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.characteristics.impl.base;

import io.github.hapjava.characteristics.ExceptionalConsumer;
import io.github.hapjava.characteristics.HomekitCharacteristicChangeCallback;
import io.github.hapjava.characteristics.impl.base.BaseCharacteristic;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.json.JsonNumber;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public abstract class IntegerCharacteristic
extends BaseCharacteristic<Integer> {
    private final int minValue;
    private final int maxValue;
    private final String unit;
    private final Optional<Supplier<CompletableFuture<Integer>>> getter;
    private final Optional<ExceptionalConsumer<Integer>> setter;

    public IntegerCharacteristic(String type, String description, int minValue, int maxValue, String unit, Optional<Supplier<CompletableFuture<Integer>>> getter, Optional<ExceptionalConsumer<Integer>> setter, Optional<Consumer<HomekitCharacteristicChangeCallback>> subscriber, Optional<Runnable> unsubscriber) {
        super(type, "int", description, getter.isPresent(), setter.isPresent(), subscriber, unsubscriber);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.unit = unit;
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    protected CompletableFuture<JsonObjectBuilder> makeBuilder(int iid) {
        return super.makeBuilder(iid).thenApply(builder -> {
            builder.add("minValue", this.minValue).add("maxValue", this.maxValue).add("minStep", 1);
            if (this.unit != null) {
                builder.add("unit", this.unit);
            }
            return builder;
        });
    }

    @Override
    protected CompletableFuture<Integer> getValue() {
        return this.getter.map(integerGetter -> (CompletableFuture)integerGetter.get()).orElse(null);
    }

    @Override
    protected void setValue(Integer value) throws Exception {
        this.setter.get().accept(value);
    }

    @Override
    protected Integer getDefault() {
        return this.minValue;
    }

    @Override
    protected Integer convert(JsonValue jsonValue) {
        return ((JsonNumber)jsonValue).intValue();
    }
}

