/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.characteristics.impl.common;

import io.github.hapjava.characteristics.CharacteristicEnum;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum ProgrammableSwitchEnum implements CharacteristicEnum
{
    SINGLE_PRESS(0),
    DOUBLE_PRESS(1),
    LONG_PRESS(3);

    private static final Map<Integer, ProgrammableSwitchEnum> reverse;
    private final int code;

    public static ProgrammableSwitchEnum fromCode(Integer code) {
        return reverse.get(code);
    }

    private ProgrammableSwitchEnum(int code) {
        this.code = code;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    static {
        reverse = Arrays.stream(ProgrammableSwitchEnum.values()).collect(Collectors.toMap(ProgrammableSwitchEnum::getCode, t -> t));
    }
}

