/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl;

import io.github.hapjava.accessories.HomekitAccessory;
import io.github.hapjava.characteristics.Characteristic;
import io.github.hapjava.services.Service;
import io.github.hapjava.services.impl.AccessoryInformationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomekitRegistry {
    private static final Logger logger = LoggerFactory.getLogger(HomekitRegistry.class);
    private final String label;
    private final Map<Integer, HomekitAccessory> accessories;
    private final Map<HomekitAccessory, Map<Integer, Service>> services = new HashMap<HomekitAccessory, Map<Integer, Service>>();
    private final Map<HomekitAccessory, Map<Integer, Characteristic>> characteristics = new HashMap<HomekitAccessory, Map<Integer, Characteristic>>();
    private boolean isAllowUnauthenticatedRequests = false;

    public HomekitRegistry(String label) {
        this.label = label;
        this.accessories = new ConcurrentHashMap<Integer, HomekitAccessory>();
        this.reset();
    }

    public synchronized void reset() {
        this.characteristics.clear();
        this.services.clear();
        for (HomekitAccessory accessory : this.accessories.values()) {
            ArrayList<Service> newServices;
            int iid = 0;
            try {
                newServices = new ArrayList<Service>(2);
                newServices.add(new AccessoryInformationService(accessory));
                for (Service service : accessory.getServices()) {
                    newServices.add(service);
                    newServices.addAll(service.getLinkedServices());
                }
            }
            catch (Exception e) {
                logger.warn("Could not instantiate services for accessory " + accessory.getName(), (Throwable)e);
                this.services.put(accessory, Collections.emptyMap());
                continue;
            }
            HashMap<Integer, Characteristic> newCharacteristicsByInterfaceId = new HashMap<Integer, Characteristic>();
            HashMap<Integer, Service> newServicesByInterfaceId = new HashMap<Integer, Service>();
            for (Service service : newServices) {
                newServicesByInterfaceId.put(++iid, service);
                for (Characteristic characteristic : service.getCharacteristics()) {
                    newCharacteristicsByInterfaceId.put(++iid, characteristic);
                }
            }
            this.services.put(accessory, newServicesByInterfaceId);
            this.characteristics.put(accessory, newCharacteristicsByInterfaceId);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public Collection<HomekitAccessory> getAccessories() {
        return this.accessories.values();
    }

    public Map<Integer, Service> getServices(Integer aid) {
        return Collections.unmodifiableMap(this.services.get(this.accessories.get(aid)));
    }

    public Map<Integer, Characteristic> getCharacteristics(Integer aid) {
        Map<Integer, Characteristic> characteristics = this.characteristics.get(this.accessories.get(aid));
        if (characteristics == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(characteristics);
    }

    public void add(HomekitAccessory accessory) {
        this.accessories.put(accessory.getId(), accessory);
    }

    public void remove(HomekitAccessory accessory) {
        this.accessories.remove(accessory.getId());
    }

    public boolean isAllowUnauthenticatedRequests() {
        return this.isAllowUnauthenticatedRequests;
    }

    public void setAllowUnauthenticatedRequests(boolean allow) {
        this.isAllowUnauthenticatedRequests = allow;
    }
}

