/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl;

import io.github.hapjava.accessories.Bridge;
import io.github.hapjava.accessories.HomekitAccessory;
import io.github.hapjava.server.HomekitAuthInfo;
import io.github.hapjava.server.HomekitWebHandler;
import io.github.hapjava.server.impl.HomekitRegistry;
import io.github.hapjava.server.impl.connections.HomekitClientConnectionFactoryImpl;
import io.github.hapjava.server.impl.connections.SubscriptionManager;
import io.github.hapjava.server.impl.jmdns.JmdnsHomekitAdvertiser;
import java.io.IOException;
import java.net.InetAddress;
import javax.jmdns.JmDNS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomekitRoot {
    private static final Logger logger = LoggerFactory.getLogger(HomekitRoot.class);
    private final JmdnsHomekitAdvertiser advertiser;
    private final HomekitWebHandler webHandler;
    private final HomekitAuthInfo authInfo;
    private final String label;
    private final HomekitRegistry registry;
    private final SubscriptionManager subscriptions = new SubscriptionManager();
    private boolean started = false;
    private int configurationIndex = 1;

    HomekitRoot(String label, HomekitWebHandler webHandler, InetAddress localhost, HomekitAuthInfo authInfo) throws IOException {
        this(label, webHandler, authInfo, new JmdnsHomekitAdvertiser(localhost));
    }

    HomekitRoot(String label, HomekitWebHandler webHandler, HomekitAuthInfo authInfo, JmdnsHomekitAdvertiser advertiser) throws IOException {
        this.advertiser = advertiser;
        this.webHandler = webHandler;
        this.authInfo = authInfo;
        this.label = label;
        this.registry = new HomekitRegistry(label);
    }

    HomekitRoot(String label, HomekitWebHandler webHandler, JmDNS jmdns, HomekitAuthInfo authInfo) throws IOException {
        this(label, webHandler, authInfo, new JmdnsHomekitAdvertiser(jmdns));
    }

    public void addAccessory(HomekitAccessory accessory) {
        if (accessory.getId() <= 1 && !(accessory instanceof Bridge)) {
            throw new IndexOutOfBoundsException("The ID of an accessory used in a bridge must be greater than 1");
        }
        this.addAccessorySkipRangeCheck(accessory);
    }

    void addAccessorySkipRangeCheck(HomekitAccessory accessory) {
        this.registry.add(accessory);
        logger.trace("Added accessory " + accessory.getName());
        if (this.started) {
            this.registry.reset();
            this.webHandler.resetConnections();
        }
    }

    public void removeAccessory(HomekitAccessory accessory) {
        this.registry.remove(accessory);
        logger.trace("Removed accessory " + accessory.getName());
        if (this.started) {
            this.registry.reset();
            this.webHandler.resetConnections();
        }
    }

    public void start() {
        this.started = true;
        this.registry.reset();
        this.webHandler.start(new HomekitClientConnectionFactoryImpl(this.authInfo, this.registry, this.subscriptions, this.advertiser)).thenAccept(port -> {
            try {
                this.refreshAuthInfo();
                this.advertiser.advertise(this.label, this.authInfo.getMac(), (int)port, this.configurationIndex, this.authInfo.getSetupId());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void stop() {
        this.advertiser.stop();
        this.webHandler.stop();
        this.subscriptions.removeAll();
        this.started = false;
    }

    public void refreshAuthInfo() throws IOException {
        this.advertiser.setDiscoverable(!this.authInfo.hasUser());
    }

    public void allowUnauthenticatedRequests(boolean allow) {
        this.registry.setAllowUnauthenticatedRequests(allow);
    }

    public void setConfigurationIndex(int revision) throws IOException {
        if (revision < 1) {
            throw new IllegalArgumentException("revision must be greater than or equal to 1");
        }
        this.configurationIndex = revision;
        if (this.started) {
            this.advertiser.setConfigurationIndex(revision);
        }
    }

    HomekitRegistry getRegistry() {
        return this.registry;
    }
}

